/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.example;

import java.io.File;
import java.util.ResourceBundle;
import unbbayes.io.NetIO;
import unbbayes.prs.Edge;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;

public class TextMode {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.example.resources.ExampleResources");

    public static void main(String[] args) throws Exception {
        ProbabilisticNetwork rede = null;
        try {
            NetIO io = new NetIO();
            rede = io.load(new File("./examples/asia.net"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        ProbabilisticNode auxVP = new ProbabilisticNode();
        auxVP.setName(resource.getString("nodeName1"));
        auxVP.setDescription(resource.getString("nodeDescription"));
        auxVP.appendState(resource.getString("stateName0"));
        auxVP.appendState(resource.getString("stateName1"));
        PotentialTable auxTabPot = auxVP.getPotentialTable();
        auxTabPot.addVariable(auxVP);
        auxTabPot.addValueAt(0, 0.99f);
        auxTabPot.addValueAt(1, 0.01f);
        rede.addNode(auxVP);
        ProbabilisticNode auxVP2 = (ProbabilisticNode)rede.getNode(resource.getString("nodeName2"));
        Edge auxArco = new Edge(auxVP, auxVP2);
        rede.addEdge(auxArco);
        rede.compile();
        float[] likelihood = new float[auxVP.getStatesSize()];
        likelihood[0] = 1.0f;
        likelihood[1] = 0.8f;
        auxVP.addLikeliHood(likelihood);
        try {
            rede.updateEvidences();
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
        }
    }
}

