/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.evaluation.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.TransferHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSplitPane leftPane;
    private JPanel nodeListPane = new JPanel(new BorderLayout());
    private JPanel buttonPane = new JPanel();
    private JPanel gcmPane = new JPanel();
    private JLabel sampleLbl;
    private JTextField sampleSizeTxt;
    private JButton runBtn;
    private JTextArea outputTxt;
    private JSplitPane rightPane;
    private JSplitPane mainPane;
    private JList nodeList;
    private JList targetNodeList;
    private JList evidenceNodeList;

    public EvaluationPane() {
        DefaultListModel listModel = new DefaultListModel();
        this.nodeList = new JList(listModel);
        this.nodeListPane.add(this.createPanelForComponent(this.setUpList(this.nodeList), "Node List"));
        this.sampleLbl = new JLabel("Sample Size:");
        this.sampleSizeTxt = new JTextField(6);
        this.runBtn = new JButton("Run");
        this.buttonPane.add(this.sampleLbl);
        this.buttonPane.add(this.sampleSizeTxt);
        this.buttonPane.add(this.runBtn);
        this.outputTxt = new JTextArea(8, 17);
        this.outputTxt.setEditable(false);
        JScrollPane outputView = new JScrollPane(this.outputTxt);
        outputView.setPreferredSize(new Dimension(200, 150));
        this.gcmPane.add(this.createPanelForComponent(outputView, "Global Confusion Matrix"));
        this.nodeListPane.add((Component)this.buttonPane, "South");
        this.leftPane = new JSplitPane(0, this.nodeListPane, this.gcmPane);
        listModel = new DefaultListModel();
        this.targetNodeList = new JList(listModel);
        listModel = new DefaultListModel();
        this.evidenceNodeList = new JList(listModel);
        this.rightPane = new JSplitPane(0, this.createPanelForComponent(this.setUpList(this.targetNodeList), "Target Node List"), this.createPanelForComponent(this.setUpList(this.evidenceNodeList), "Evidence Node List"));
        this.mainPane = new JSplitPane(1, this.leftPane, this.rightPane);
        this.add(this.mainPane);
    }

    public void fillNodeList(List<String> valueList) {
        DefaultListModel listModel = (DefaultListModel)this.nodeList.getModel();
        for (String value : valueList) {
            listModel.addElement(value);
        }
    }

    public String getSampleSizeText() {
        return this.sampleSizeTxt.getText();
    }

    public List<String> getTargetNodeNameList() {
        ArrayList<String> targetNodeNameList = new ArrayList<String>();
        DefaultListModel listModel = (DefaultListModel)this.targetNodeList.getModel();
        int i = 0;
        while (i < listModel.size()) {
            targetNodeNameList.add((String)listModel.get(i));
            ++i;
        }
        return targetNodeNameList;
    }

    public void setRunBtnActionListener(ActionListener action) {
        this.runBtn.addActionListener(action);
    }

    public List<String> getEvidenceNodeNameList() {
        ArrayList<String> evidenceNodeNameList = new ArrayList<String>();
        DefaultListModel listModel = (DefaultListModel)this.evidenceNodeList.getModel();
        int i = 0;
        while (i < listModel.size()) {
            evidenceNodeNameList.add((String)listModel.get(i));
            ++i;
        }
        return evidenceNodeNameList;
    }

    public void setOutputText(String output) {
        this.outputTxt.setText(output);
    }

    private JScrollPane setUpList(JList list) {
        list.setVisibleRowCount(-1);
        list.getSelectionModel().setSelectionMode(2);
        list.setTransferHandler(new ListTransferHandler());
        list.setDragEnabled(true);
        list.setDropMode(DropMode.INSERT);
        JScrollPane listView = new JScrollPane(list);
        listView.setPreferredSize(new Dimension(200, 150));
        return listView;
    }

    public JPanel createPanelForComponent(JComponent comp, String title) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)comp, "Center");
        if (title != null) {
            panel.setBorder(BorderFactory.createTitledBorder(title));
        }
        return panel;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Evaluation Test");
        EvaluationPane pane = new EvaluationPane();
        ArrayList<String> nodeNameList = new ArrayList<String>();
        nodeNameList.add("Node1");
        nodeNameList.add("Node2");
        nodeNameList.add("Node3");
        nodeNameList.add("Node4");
        pane.fillNodeList(nodeNameList);
        frame.add(pane);
        frame.setSize(800, 450);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        pane.setOutputText("aasdfasdfasfasdfsdf\nasdfasdf\nasfasfd\n");
    }

    public class ListTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        private int[] indices = null;
        private int addIndex = -1;
        private int addCount = 0;

        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        protected Transferable createTransferable(JComponent c) {
            JList list = (JList)c;
            this.indices = list.getSelectedIndices();
            Object[] values = list.getSelectedValues();
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < values.length) {
                Object val = values[i];
                buff.append(val == null ? "" : val.toString());
                if (i != values.length - 1) {
                    buff.append("\n");
                }
                ++i;
            }
            return new StringSelection(buff.toString());
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        public boolean importData(TransferHandler.TransferSupport info) {
            String data;
            if (!info.isDrop()) {
                return false;
            }
            JList list = (JList)info.getComponent();
            DefaultListModel listModel = (DefaultListModel)list.getModel();
            JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
            int index = dl.getIndex();
            boolean insert = dl.isInsert();
            Transferable t = info.getTransferable();
            try {
                data = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return false;
            }
            String[] values = data.split("\n");
            this.addIndex = index;
            this.addCount = values.length;
            int i = 0;
            while (i < values.length) {
                if (insert) {
                    listModel.add(index++, values[i]);
                } else if (index < listModel.getSize()) {
                    listModel.set(index++, values[i]);
                } else {
                    listModel.add(index++, values[i]);
                }
                ++i;
            }
            return true;
        }

        protected void exportDone(JComponent c, Transferable data, int action) {
            JList source = (JList)c;
            DefaultListModel listModel = (DefaultListModel)source.getModel();
            if (action == 2) {
                int i = this.indices.length - 1;
                while (i >= 0) {
                    listModel.remove(this.indices[i]);
                    --i;
                }
            }
            this.indices = null;
            this.addCount = 0;
            this.addIndex = -1;
        }
    }
}

