/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import unbbayes.draw.DrawElement;

public class DrawTwoBaseRectangle
extends DrawElement {
    private Point2D.Double position;
    private Point2D.Double size;

    public DrawTwoBaseRectangle(Point2D.Double position, Point2D.Double size) {
        this.position = position;
        this.size = size;
    }

    public void paint(Graphics2D graphics) {
        graphics.setColor(this.getFillColor());
        GeneralPath parallelogram = new GeneralPath();
        parallelogram.moveTo((float)(this.position.x - 0.5 * this.size.x), (float)(this.position.y - 0.5 * this.size.y));
        parallelogram.lineTo((float)(this.position.x - 0.35 * this.size.x), (float)(this.position.y + 0.5 * this.size.y));
        parallelogram.lineTo((float)(this.position.x + 0.35 * this.size.x), (float)(this.position.y + 0.5 * this.size.y));
        parallelogram.lineTo((float)(this.position.x + 0.5 * this.size.x), (float)(this.position.y - 0.5 * this.size.y));
        parallelogram.closePath();
        graphics.fill(parallelogram);
        if (this.isSelected()) {
            graphics.setColor(DrawTwoBaseRectangle.getSelectionColor());
            graphics.setStroke(new BasicStroke(2.0f));
        } else {
            graphics.setColor(DrawTwoBaseRectangle.getOutlineColor());
        }
        graphics.draw(parallelogram);
        graphics.setStroke(new BasicStroke(1.0f));
        super.paint(graphics);
    }
}

