/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.AttributedString;
import unbbayes.draw.DrawElement;

public class DrawText
extends DrawElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String text;
    private Point2D.Double position;

    public DrawText(String text, Point2D.Double position) {
        this.text = text;
        this.position = position;
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        AttributedString as = new AttributedString(this.text);
        Font serifFont = new Font("Serif", 0, 12);
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        double alt = serifFont.getStringBounds(this.text, frc).getHeight();
        double lar = serifFont.getStringBounds(this.text, frc).getWidth();
        as.addAttribute(TextAttribute.FONT, serifFont);
        as.addAttribute(TextAttribute.FOREGROUND, Color.black);
        graphics.setColor(this.getFillColor());
        graphics.drawString(as.getIterator(), (int)(this.position.x - lar / 2.0), (int)(this.position.y + alt / 2.0));
    }

    public void setText(String text) {
        this.text = text;
    }
}

