/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import unbbayes.draw.DrawElement;
import unbbayes.util.GeometricUtil;

public class DrawLine
extends DrawElement {
    private Point2D.Double startPosition;
    private Point2D.Double endPosition;
    private Point2D.Double size;
    private boolean bNew;

    public DrawLine(Point2D.Double startPosition, Point2D.Double endPosition, Point2D.Double size) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.size = size;
    }

    public void paint(Graphics2D graphics) {
        Point2D.Double point1 = GeometricUtil.getCircunferenceTangentPoint(this.startPosition, this.endPosition, (this.size.x + this.size.y) / 4.0);
        Point2D.Double point2 = !this.isNew() ? GeometricUtil.getCircunferenceTangentPoint(this.endPosition, this.startPosition, (this.size.x + this.size.y) / 4.0) : this.endPosition;
        if (this.isSelected()) {
            graphics.setColor(DrawLine.getSelectionColor());
            graphics.setStroke(new BasicStroke(2.0f));
        } else {
            graphics.setColor(this.getFillColor());
        }
        graphics.drawLine((int)point1.x, (int)point1.y, (int)point2.x, (int)point2.y);
        graphics.setStroke(new BasicStroke(1.0f));
        super.paint(graphics);
    }

    public void setNew(boolean bNew) {
        this.bNew = bNew;
    }

    public boolean isNew() {
        return this.bNew;
    }
}

