/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import unbbayes.draw.DrawElement;

public class DrawDashRectangle
extends DrawElement {
    private Point2D.Double startPosition;
    private Point2D.Double endPosition;

    public DrawDashRectangle(Point2D.Double beginSelectionPoint, Point2D.Double endSelectionPoint) {
        this.startPosition = beginSelectionPoint;
        this.endPosition = endSelectionPoint;
    }

    public void paint(Graphics2D graphics) {
        graphics.setColor(this.getFillColor());
        float[] dash = new float[]{10.0f, 10.0f};
        graphics.setStroke(new BasicStroke(1.0f, 0, 2, 10.0f, dash, 10.0f));
        if (this.startPosition.getX() <= this.endPosition.getX() && this.startPosition.getY() <= this.endPosition.getY()) {
            graphics.drawRect((int)this.startPosition.getX(), (int)this.startPosition.getY(), (int)(this.endPosition.getX() - this.startPosition.getX()), (int)(this.endPosition.getY() - this.startPosition.getY()));
        } else if (this.startPosition.getX() > this.endPosition.getX() && this.startPosition.getY() <= this.endPosition.getY()) {
            graphics.drawRect((int)this.endPosition.getX(), (int)this.startPosition.getY(), (int)(this.startPosition.getX() - this.endPosition.getX()), (int)(this.endPosition.getY() - this.startPosition.getY()));
        } else if (this.startPosition.getX() <= this.endPosition.getX() && this.startPosition.getY() > this.endPosition.getY()) {
            graphics.drawRect((int)this.startPosition.getX(), (int)this.endPosition.getY(), (int)(this.endPosition.getX() - this.startPosition.getX()), (int)(this.startPosition.getY() - this.endPosition.getY()));
        } else {
            graphics.drawRect((int)this.endPosition.getX(), (int)this.endPosition.getY(), (int)(this.startPosition.getX() - this.endPosition.getX()), (int)(this.startPosition.getY() - this.endPosition.getY()));
        }
        graphics.setStroke(new BasicStroke(1.0f));
        super.paint(graphics);
    }
}

