/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import unbbayes.draw.DrawElement;
import unbbayes.util.GeometricUtil;

public class DrawArrow
extends DrawElement {
    private Point2D.Double startPosition;
    private Point2D.Double endPosition;
    private Point2D.Double size;
    private boolean bNew;

    public DrawArrow(Point2D.Double startPosition, Point2D.Double endPosition, Point2D.Double size) {
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.size = size;
    }

    public void paint(Graphics2D graphics) {
        double y4;
        double x4;
        double y3;
        double x3;
        Point2D.Double point1;
        GeneralPath arrow = new GeneralPath();
        double x1 = this.startPosition.x;
        double y1 = this.startPosition.y;
        double x2 = this.endPosition.x;
        double y2 = this.endPosition.y;
        if (!this.isNew()) {
            point1 = GeometricUtil.getCircunferenceTangentPoint(this.endPosition, this.startPosition, (this.size.x + this.size.y) / 4.0 + 10.0);
            Point2D.Double point2 = GeometricUtil.getCircunferenceTangentPoint(this.endPosition, this.startPosition, (this.size.x + this.size.y) / 4.0);
            x2 = point2.x;
            y2 = point2.y;
        } else {
            point1 = GeometricUtil.getCircunferenceTangentPoint(this.endPosition, this.startPosition, 10.0);
        }
        if (x1 > x2 && y1 > y2 || x1 < x2 && y1 < y2) {
            x3 = point1.x + 5.0 * Math.abs(Math.cos(Math.atan((x2 - x1) / (y1 - y2))));
            y3 = point1.y - 5.0 * Math.abs(Math.sin(Math.atan((x2 - x1) / (y1 - y2))));
            x4 = point1.x - 5.0 * Math.abs(Math.cos(Math.atan((x2 - x1) / (y1 - y2))));
            y4 = point1.y + 5.0 * Math.abs(Math.sin(Math.atan((x2 - x1) / (y1 - y2))));
        } else {
            x3 = point1.x + 5.0 * Math.cos(Math.atan((x1 - x2) / (y1 - y2)));
            y3 = point1.y - 5.0 * Math.sin(Math.atan((x1 - x2) / (y1 - y2)));
            x4 = point1.x - 5.0 * Math.cos(Math.atan((x1 - x2) / (y1 - y2)));
            y4 = point1.y + 5.0 * Math.sin(Math.atan((x1 - x2) / (y1 - y2)));
        }
        arrow.moveTo((float)x3, (float)y3);
        arrow.lineTo((float)x2, (float)y2);
        arrow.lineTo((float)x4, (float)y4);
        arrow.lineTo((float)x3, (float)y3);
        if (this.isSelected()) {
            graphics.setColor(DrawArrow.getSelectionColor());
            graphics.setStroke(new BasicStroke(2.0f));
        } else {
            graphics.setColor(this.getFillColor());
        }
        graphics.fill(arrow);
        graphics.setStroke(new BasicStroke(1.0f));
        super.paint(graphics);
    }

    public void setNew(boolean bNew) {
        this.bNew = bNew;
    }

    public boolean isNew() {
        return this.bNew;
    }
}

