/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.utils;

public class Statistics {
    protected static final double MACHEP = (double)1.110223E-16f;
    protected static final double MAXLOG = 709.782712893384;
    protected static final double MINLOG = -745.1332191019412;
    protected static final double MAXGAM = 171.6243769563027;
    protected static final double SQTPI = 2.5066282746310007;
    protected static final double SQRTH = 0.7071067811865476;
    protected static final double LOGPI = 1.1447298858494002;
    protected static final double big = 4.503599627370496E15;
    protected static final double biginv = 2.220446049250313E-16;

    public static double normalProbability(double a) {
        double y;
        double x = a * 0.7071067811865476;
        double z = Math.abs(x);
        if (z < 0.7071067811865476) {
            y = 0.5 + 0.5 * Statistics.errorFunction(x);
        } else {
            y = 0.5 * Statistics.errorFunctionComplemented(z);
            if (x > 0.0) {
                y = 1.0 - y;
            }
        }
        return y;
    }

    static double errorFunction(double x) {
        double[] T = new double[]{9.604973739870516, 90.02601972038427, 2232.005345946843, 7003.325141128051, 55592.30130103949};
        double[] U = new double[]{33.56171416475031, 521.3579497801527, 4594.323829709801, 22629.000061389095, 49267.39426086359};
        if (Math.abs(x) > 1.0) {
            return 1.0 - Statistics.errorFunctionComplemented(x);
        }
        double z = x * x;
        double y = x * Statistics.polevl(z, T, 4) / Statistics.p1evl(z, U, 5);
        return y;
    }

    static double errorFunctionComplemented(double a) {
        double q;
        double p;
        double[] P = new double[]{2.461969814735305E-10, 0.5641895648310689, 7.463210564422699, 48.63719709856814, 196.5208329560771, 526.4451949954773, 934.5285271719576, 1027.5518868951572, 557.5353353693994};
        double[] Q = new double[]{13.228195115474499, 86.70721408859897, 354.9377788878199, 975.7085017432055, 1823.9091668790973, 2246.3376081871097, 1656.6630919416134, 557.5353408177277};
        double[] R = new double[]{0.5641895835477551, 1.275366707599781, 5.019050422511805, 6.160210979930536, 7.4097426995044895, 2.9788666537210022};
        double[] S = new double[]{2.2605286322011726, 9.396035249380015, 12.048953980809666, 17.08144507475659, 9.608968090632859, 3.369076451000815};
        double x = a < 0.0 ? -a : a;
        if (x < 1.0) {
            return 1.0 - Statistics.errorFunction(a);
        }
        double z = -a * a;
        if (z < -709.782712893384) {
            if (a < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        z = Math.exp(z);
        if (x < 8.0) {
            p = Statistics.polevl(x, P, 8);
            q = Statistics.p1evl(x, Q, 8);
        } else {
            p = Statistics.polevl(x, R, 5);
            q = Statistics.p1evl(x, S, 6);
        }
        double y = z * p / q;
        if (a < 0.0) {
            y = 2.0 - y;
        }
        if (y == 0.0) {
            if (a < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        return y;
    }

    static double p1evl(double x, double[] coef, int N) {
        double ans = x + coef[0];
        int i = 1;
        while (i < N) {
            ans = ans * x + coef[i];
            ++i;
        }
        return ans;
    }

    static double polevl(double x, double[] coef, int N) {
        double ans = coef[0];
        int i = 1;
        while (i <= N) {
            ans = ans * x + coef[i];
            ++i;
        }
        return ans;
    }

    public static double computeFProb(int dfn, int dfd, double f) {
        if ((double)dfn > 0.01 && (double)dfd > 0.01 && f > 1.0E-10) {
            return Statistics.probf(dfn, dfd, f);
        }
        return -1.0;
    }

    private static double probf(int dfn, int dfd, double f) {
        int iv = 0;
        int dfnAux = dfn;
        int dfdAux = dfd;
        if (Math.floor(dfn / 2) * 2.0 == (double)dfn) {
            return Statistics.l401(dfn, f, dfd, iv);
        }
        if (Math.floor(dfd / 2) * 2.0 != (double)dfd) {
            return Statistics.l504(dfn, f, dfd, iv);
        }
        f = 1.0 / f;
        iv = 1;
        dfn = dfdAux;
        dfd = dfnAux;
        return Statistics.l401(dfn, f, dfd, iv);
    }

    private static double l504(int a, double f, int b, int iv) {
        double rr;
        double x;
        int i;
        double n;
        double c;
        double q = (double)a * f / ((double)a * f + (double)b);
        double sa = Math.sqrt(q);
        double sl = Math.log(sa);
        double ca = Math.sqrt(1.0 - q);
        double cl = Math.log(ca);
        double al = Math.atan(sa / Math.sqrt(-sa * sa + 1.0));
        double fp = 1.0 - 2.0 * al / Math.PI;
        double r = 0.0;
        if (b != 1) {
            c = Math.log(2.0 * sa / Math.PI);
            fp -= Math.exp(c + cl);
            if (b != 3) {
                n = Math.floor((b - 3) / 2);
                i = 1;
                while ((double)i <= n) {
                    x = 2 * i + 1;
                    rr = (r += Math.log((x - 1.0) / x)) + cl * x + c;
                    if (rr > -78.4) {
                        fp -= Math.exp(rr);
                    }
                    ++i;
                }
            }
        }
        if (a != 1) {
            c = r;
            if (b > 1) {
                c += Math.log(b - 1);
            }
            if ((c += Math.log(0.6366197723675814) + sl + cl * (double)b) > -78.4) {
                fp += Math.exp(c);
            }
            if (a != 3) {
                n = Math.floor((a - 3) / 2);
                r = 0.0;
                i = 1;
                while ((double)i <= n) {
                    x = i * 2 + 1;
                    rr = (r += Math.log(((double)b + x - 2.0) / x)) + sl * (x - 1.0) + c;
                    if (rr > -78.4) {
                        fp += Math.exp(rr);
                    }
                    ++i;
                }
            }
        }
        return fp;
    }

    private static double l401(int a, double f, int b, int iv) {
        double q = (double)a * f / ((double)a * f + (double)b);
        double ql = Math.log(q);
        double fp = 0.0;
        double c = Math.log(1.0 - q) * (double)b / 2.0;
        if (c > -78.4) {
            fp = Math.exp(c);
        }
        if (a != 2) {
            double n = Math.floor(a / 2 - 1);
            double r = 0.0;
            int i = 1;
            while ((double)i <= n) {
                double x = 2 * i;
                if ((r += Math.log((double)b + x - 2.0) - Math.log(x) + ql) + c > -78.4) {
                    fp += Math.exp(r + c);
                }
                ++i;
            }
        }
        if (iv == 1) {
            fp = 1.0 - fp;
        }
        return fp;
    }
}

