/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.preprocessor.imbalanceddataset;

import java.util.Arrays;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;
import unbbayes.datamining.preprocessor.imbalanceddataset.Batch;
import unbbayes.datamining.preprocessor.imbalanceddataset.ClusterBasedUtils;
import unbbayes.datamining.preprocessor.imbalanceddataset.Smote;
import unbbayes.datamining.preprocessor.imbalanceddataset.Utils;

public class Cclear
extends Batch {
    protected Instance[] instances;
    protected int numInstances;
    protected int[][] clusters;
    protected int[][] clustersOriginal;
    protected int[] clustersClass;
    private int numClusters;
    private float[] clustersPositiveFrequency;
    protected boolean[] deleteIndex;
    protected boolean[] classClusterized;
    private int[][][] smoteNN;
    private ClusterBasedUtils clusterBasedUtils;
    private ClusterBasedUtils clusterBasedUtilsBackup;
    private Smote smote;
    private static boolean useRatio = true;
    private static boolean useK = true;
    private static boolean useOverThresh = true;
    private static boolean usePosThresh = true;
    private static boolean useNegThresh = true;
    private static boolean useCleaning = true;

    public Cclear(InstanceSet instanceSet, PreprocessorParameters parameters) {
        super(useRatio, useK, useOverThresh, usePosThresh, useNegThresh, useCleaning, instanceSet, parameters);
        this.preprocessorName = "Cclear";
        this.classClusterized = new boolean[2];
        Arrays.fill(this.classClusterized, false);
    }

    public Cclear(ClusterBasedUtils clusterBasedUtils, InstanceSet instanceSet) throws Exception {
        this(instanceSet, null);
        this.setClusterInfo(clusterBasedUtils);
    }

    public Cclear(ClusterBasedUtils clusterBasedUtils, InstanceSet instanceSet, PreprocessorParameters parameters) throws Exception {
        this(instanceSet, parameters);
        this.setClusterInfo(clusterBasedUtils);
    }

    public Cclear(InstanceSet instanceSet) throws Exception {
        this(instanceSet, null);
        this.setClusterInfo(null);
    }

    public void setClusterInfo(ClusterBasedUtils clusterBasedUtils) throws Exception {
        this.clusterBasedUtils = clusterBasedUtils;
    }

    private void initializeClusters() throws Exception {
        this.clusters = this.clusterBasedUtils.getClusters(this.k);
        this.numClusters = this.clusterBasedUtils.getNumClusters(this.k);
        this.smoteNN = this.clusterBasedUtils.getSmoteNN(this.k);
        this.updateClustersPositiveFrequency();
    }

    protected void run() throws Exception {
        if (this.instanceSet.isNominal()) {
            throw new Exception("Pau!");
        }
        this.initializeClusters();
        this.oversamplingThreshold = this.autoOversamplingThreshold ? (this.oversamplingThreshold *= this.instanceSet.getClassFrequency(this.positiveClass)) : this.instanceSet.getClassFrequency(this.positiveClass);
        this.oversampling(this.instanceSet, this.oversamplingThreshold);
        if (this.clean) {
            this.initialize();
            this.rebuildClusters();
            this.clean(this.positiveThreshold, this.positiveClass);
            this.clean((double)(1.0f - this.negativeThreshold) + 4.0E-9, this.negativeClass);
            this.removeMarkedInstances();
            this.rollBackClusters();
        }
        if (this.instanceSet.getClassDistribution(true)[0] == 0.0f && this.instanceSet.getClassDistribution(true)[1] == 0.0f) {
            boolean bl = true;
        }
    }

    private void oversampling(InstanceSet instanceSet, float positiveThreshold) throws Exception {
        this.assignClusterClass(positiveThreshold);
        int[] cluster = null;
        int counter = 0;
        int clusterID = 0;
        while (clusterID < this.numClusters) {
            if (this.clustersClass[clusterID] == this.positiveClass) {
                cluster = this.clusters[clusterID];
                int i = 0;
                while (i < cluster.length) {
                    int inst = cluster[i];
                    if (this.instances[inst].getClassValue() == this.positiveClass) {
                        counter = (int)((float)counter + instanceSet.instances[inst].getWeight());
                    }
                    ++i;
                }
            }
            ++clusterID;
        }
        float[] dist = instanceSet.getClassDistribution(false);
        float proportion = dist[this.negativeClass] - dist[this.positiveClass] + (float)counter;
        proportion *= (float)this.ratio;
        proportion /= (float)counter * (float)(100 - this.ratio);
        int clusterID2 = 0;
        while (clusterID2 < this.numClusters) {
            if (this.clustersClass[clusterID2] == this.positiveClass && (cluster = this.smoteCluster(clusterID2, proportion, this.positiveClass)) != null) {
                this.clusters[clusterID2] = cluster;
            }
            ++clusterID2;
        }
    }

    public int[] smoteCluster(int clusterID, double proportion, int classValue) throws Exception {
        int counter = 0;
        int[] cluster = this.clusters[clusterID];
        int clusterLength = cluster.length;
        int[] instancesIDsTmp = new int[clusterLength];
        int[][] smoteNNTmp = new int[clusterLength][];
        int i = 0;
        while (i < clusterLength) {
            int inst = cluster[i];
            if (this.instanceSet.getInstance(inst).getClassValue() == classValue) {
                instancesIDsTmp[counter] = inst;
                smoteNNTmp[counter] = this.smoteNN[clusterID][i];
                ++counter;
            }
            ++i;
        }
        if (counter < 1) {
            return null;
        }
        int[] instancesIDs = new int[counter];
        int[][] smoteNN = new int[counter][];
        int i2 = 0;
        while (i2 < counter) {
            instancesIDs[i2] = instancesIDsTmp[i2];
            smoteNN[i2] = smoteNNTmp[i2];
            ++i2;
        }
        int[] newInstances = null;
        this.smote.setNearestNeighborsIDs(smoteNN);
        this.smote.setProportion(proportion);
        newInstances = this.smote.run(instancesIDs);
        int numNewInstances = newInstances.length;
        int newClusterSize = numNewInstances + clusterLength;
        int[] newCluster = new int[newClusterSize];
        int i3 = 0;
        while (i3 < clusterLength) {
            newCluster[i3] = cluster[i3];
            ++i3;
        }
        i3 = clusterLength;
        while (i3 < newClusterSize) {
            newCluster[i3] = newInstances[i3 - clusterLength];
            ++i3;
        }
        return newCluster;
    }

    private void assignClusterClass(double positiveThreshold) throws Exception {
        this.clustersClass = new int[this.numClusters];
        int clusterID = 0;
        while (clusterID < this.numClusters) {
            this.clustersClass[clusterID] = (double)this.clustersPositiveFrequency[clusterID] >= positiveThreshold ? this.positiveClass : this.negativeClass;
            ++clusterID;
        }
        boolean pause = true;
    }

    private void clean(double cleanFactor, int classValue) throws Exception {
        this.assignClusterClass(cleanFactor);
        this.clean(classValue);
    }

    private void clean(int clusterClass) throws Exception {
        int instanceClassDesired;
        int clusterClassDesired;
        if (clusterClass == this.positiveClass) {
            clusterClassDesired = this.positiveClass;
            instanceClassDesired = this.negativeClass;
        } else {
            clusterClassDesired = this.negativeClass;
            instanceClassDesired = this.positiveClass;
        }
        int clusterID = 0;
        while (clusterID < this.numClusters) {
            if (this.clustersClass[clusterID] == clusterClassDesired) {
                int[] cluster = this.clusters[clusterID];
                int clusterLength = cluster.length;
                int i = 0;
                while (i < clusterLength) {
                    int inst = cluster[i];
                    Instance instance = this.instanceSet.getInstance(inst);
                    if (instance.getClassValue() == instanceClassDesired) {
                        this.deleteIndex[inst] = true;
                    }
                    ++i;
                }
            }
            ++clusterID;
        }
    }

    private void removeMarkedInstances() {
        Utils.removeMarkedInstances(this.instanceSet, this.deleteIndex);
        this.deleteIndex = new boolean[this.instanceSet.numInstances];
        Arrays.fill(this.deleteIndex, false);
    }

    private void rebuildClusters() throws Exception {
        this.initialize();
        this.clusterBasedUtilsBackup = this.clusterBasedUtils;
        this.clusterBasedUtils = new ClusterBasedUtils(this.instanceSet);
        this.setClusterInfo(this.clusterBasedUtils);
        this.initializeClusters();
    }

    private void rollBackClusters() throws Exception {
        if (this.clusterBasedUtilsBackup != null) {
            this.clusterBasedUtils = this.clusterBasedUtilsBackup;
            this.setClusterInfo(this.clusterBasedUtils);
        }
    }

    private void initialize() {
        this.smote = new Smote(this.instanceSet);
        this.smote.setInstanceSet(this.instanceSet);
        this.numInstances = this.instanceSet.numInstances;
        this.instances = this.instanceSet.instances;
        this.deleteIndex = new boolean[this.numInstances];
        Arrays.fill(this.deleteIndex, false);
    }

    protected void updateClustersPositiveFrequency() {
        int numClusters = this.clusters.length;
        this.clustersPositiveFrequency = new float[numClusters];
        int clusterID = 0;
        while (clusterID < numClusters) {
            float dist;
            this.clustersPositiveFrequency[clusterID] = dist = this.computeClustersPositiveFrequency(clusterID);
            ++clusterID;
        }
        boolean pause = true;
    }

    private float computeClustersPositiveFrequency(int clusterID) {
        float numPositives = 0.0f;
        float clusterSize = 0.0f;
        int[] cluster = this.clusters[clusterID];
        int clusterLength = cluster.length;
        int i = 0;
        while (i < clusterLength) {
            int inst = cluster[i];
            if (!this.deleteIndex[inst]) {
                Instance instance = this.instanceSet.getInstance(inst);
                float weight = instance.getWeight();
                if (instance.getClassValue() == this.positiveClass) {
                    numPositives += weight;
                }
                clusterSize += weight;
            }
            ++i;
        }
        return numPositives / clusterSize;
    }

    public void setInstanceSet(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
        this.initialize();
    }

    protected void initializeBatch(InstanceSet instanceSet) {
        this.setInstanceSet(instanceSet);
    }
}

