/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.neuralnetwork;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import unbbayes.controller.IconController;
import unbbayes.datamining.classifiers.NeuralNetwork;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.Utils;
import unbbayes.datamining.gui.AttributesTree;
import unbbayes.datamining.gui.IInferencePanel;

public class InferencePanel
extends JPanel
implements IInferencePanel {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private JPanel panelMessages = new JPanel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JScrollPane treeScrollPane;
    private BorderLayout borderLayout4 = new BorderLayout();
    private AttributesTree attributesTree;
    private JSplitPane splitPane1 = new JSplitPane();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JToolBar jToolBar1 = new JToolBar();
    private JButton expandButton = new JButton();
    private JButton colapseButton = new JButton();
    private JButton classifyButton = new JButton();
    private Icon colapseIcon;
    private Icon expandIcon;
    private Icon propagateIcon;
    private DecimalFormat numFormat = new DecimalFormat("##0.0");
    private BorderLayout borderLayout6 = new BorderLayout();
    private JSplitPane splitPane2 = new JSplitPane();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JScrollPane jScrollPane3 = new JScrollPane();
    private JTextPane textPaneResults = new JTextPane();
    private JTextPane textPaneRules = new JTextPane();
    private NeuralNetwork neuralNetwork;
    protected IconController iconController = IconController.getInstance();

    public InferencePanel() {
        try {
            this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.neuralnetwork.resources.NeuralNetworkResource");
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.colapseIcon = this.iconController.getColapseIcon();
        this.expandIcon = this.iconController.getExpandIcon();
        this.propagateIcon = this.iconController.getPropagateIcon();
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout5);
        this.jPanel2.setLayout(this.borderLayout2);
        this.panelMessages.setLayout(this.borderLayout3);
        this.jPanel3.setLayout(this.borderLayout4);
        this.expandButton.setToolTipText(this.resource.getString("expandToolTip"));
        this.expandButton.setIcon(this.expandIcon);
        this.expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InferencePanel.this.expandButton_actionPerformed(e);
            }
        });
        this.colapseButton.setToolTipText(this.resource.getString("collapseToolTip"));
        this.colapseButton.setIcon(this.colapseIcon);
        this.colapseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InferencePanel.this.colapseButton_actionPerformed(e);
            }
        });
        this.classifyButton.setToolTipText(this.resource.getString("inference"));
        this.classifyButton.setIcon(this.propagateIcon);
        this.classifyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InferencePanel.this.classifyButton_actionPerformed(e);
            }
        });
        this.jPanel4.setLayout(this.borderLayout6);
        this.splitPane2.setOrientation(0);
        this.textPaneResults.setEditable(false);
        this.textPaneRules.setEditable(false);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.splitPane1.add((Component)this.jPanel4, "right");
        this.jPanel4.add((Component)this.splitPane2, "Center");
        this.jPanel1.add((Component)this.splitPane1, "Center");
        this.splitPane1.add((Component)this.jPanel2, "left");
        this.add((Component)this.panelMessages, "South");
        this.add((Component)this.jToolBar1, "North");
        this.jToolBar1.add((Component)this.colapseButton, null);
        this.jToolBar1.add((Component)this.expandButton, null);
        this.jToolBar1.add((Component)this.classifyButton, null);
        this.splitPane2.add((Component)this.jScrollPane2, "top");
        this.jScrollPane2.getViewport().add((Component)this.textPaneResults, null);
        this.splitPane2.add((Component)this.jScrollPane3, "bottom");
        this.jScrollPane3.getViewport().add((Component)this.textPaneRules, null);
        this.jToolBar1.setFloatable(false);
        this.splitPane1.setDividerLocation(20);
    }

    public void setNetwork(NeuralNetwork neuralNetwork) {
        this.neuralNetwork = neuralNetwork;
        this.attributesTree = new AttributesTree();
        this.attributesTree.setAttributes(neuralNetwork.getAttributeVector(), neuralNetwork.getClassIndex());
        this.attributesTree.expandTree();
        this.attributesTree.setController(this);
        this.splitPane1.setDividerLocation(0.4);
        this.splitPane2.setDividerLocation(0.6);
        this.treeScrollPane = new JScrollPane(this.attributesTree);
        this.jPanel3.removeAll();
        this.jPanel3.add((Component)this.treeScrollPane, "Center");
        this.jPanel3.updateUI();
        this.textPaneResults.setText("");
        this.textPaneRules.setText("");
    }

    private void printResults(float[] results, Instance instance) {
        Attribute[] attributeVector = this.neuralNetwork.getAttributeVector();
        DecimalFormat numFormat = new DecimalFormat("##0.000");
        Attribute classAtt = attributeVector[this.neuralNetwork.getClassIndex()];
        String[] initString = new String[results.length + 1];
        initString[0] = String.valueOf(this.resource.getString("class")) + ": " + classAtt.getAttributeName() + "\n";
        int i = 0;
        while (i < results.length) {
            initString[i + 1] = "- " + classAtt.value(i) + ":  " + numFormat.format(results[i]) + "\n";
            ++i;
        }
        String[] initStyles = new String[initString.length];
        initStyles[0] = "largeBold";
        int maxValue = Utils.maxIndex(results);
        i = 0;
        while (i < results.length) {
            initStyles[i + 1] = i == maxValue ? "bold" : "regular";
            ++i;
        }
        this.initStylesForTextPane(this.textPaneResults);
        Document docResults = this.textPaneResults.getDocument();
        try {
            docResults.remove(0, docResults.getLength());
            i = 0;
            while (i < initString.length) {
                docResults.insertString(docResults.getLength(), initString[i], this.textPaneResults.getStyle(initStyles[i]));
                ++i;
            }
        }
        catch (BadLocationException ble) {
            System.out.println("InferencePanel - Couldn't insert initial text.");
        }
    }

    private void initStylesForTextPane(JTextPane textPane) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = textPane.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        StyleConstants.setFontSize(def, 16);
        Style s = textPane.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = textPane.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = textPane.addStyle("large", regular);
        StyleConstants.setFontSize(s, 18);
        s = textPane.addStyle("largeBold", s);
        StyleConstants.setBold(s, true);
    }

    public void printSelectedAttributes(Instance instance) {
        Attribute[] attArray = this.neuralNetwork.getAttributeVector();
        String rule = new String();
        int classIndex = this.neuralNetwork.getClassIndex();
        int numAtt = attArray.length;
        Document docRules = this.textPaneRules.getDocument();
        this.initStylesForTextPane(this.textPaneRules);
        int attIndex = 0;
        while (attIndex < numAtt) {
            if (attIndex != classIndex && !instance.isMissing(attIndex)) {
                Attribute att = attArray[attIndex];
                String value = att.isNominal() ? att.value((int)instance.getValue(attIndex)) : String.valueOf(instance.getValue(attIndex));
                rule = String.valueOf(rule) + att.getAttributeName() + ": " + value + "\n";
            }
            ++attIndex;
        }
        try {
            docRules.remove(0, docRules.getLength());
            docRules.insertString(docRules.getLength(), rule, this.textPaneRules.getStyle("bold"));
        }
        catch (BadLocationException ble) {
            System.out.println("InferencePanel - Couldn't insert initial text.");
        }
    }

    private void classifyButton_actionPerformed(ActionEvent e) {
        try {
            Instance instance = this.attributesTree.getInstance();
            this.printResults(this.neuralNetwork.distributionForInstance(instance), instance);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private void expandButton_actionPerformed(ActionEvent e) {
        this.attributesTree.expandTree();
        this.repaint();
    }

    private void colapseButton_actionPerformed(ActionEvent e) {
        this.attributesTree.collapseTree();
    }
}

