/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.neuralnetwork;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class AdvancedOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel advancedOptions = new JPanel();
    private JPanel learningRatePanel = new JPanel();
    private JPanel hiddenLayerPanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JCheckBox learningRateCheckBox = new JCheckBox();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private GridLayout gridLayout2 = new GridLayout();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private BorderLayout borderLayout4 = new BorderLayout();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JCheckBox hiddenLayerCheckBox = new JCheckBox();
    private JSpinner hiddenSizeSpinner = new JSpinner();
    private JPanel trainningTimePanel = new JPanel();
    private BorderLayout borderLayout6 = new BorderLayout();
    private JPanel jPanel4 = new JPanel();
    private GridLayout gridLayout3 = new GridLayout();
    private JLabel labelTimeLimit = new JLabel();
    private JSpinner trainningTimeSpinner = new JSpinner();
    private JSpinner errorVariationSpinner = new JSpinner();
    private JPanel activationFunctionSteepPanel = new JPanel();
    private BorderLayout borderLayout7 = new BorderLayout();
    private JSpinner fuctionSteepSpinner = new JSpinner();
    private SpinnerNumberModel hiddenLayerSizeSpinnerModel = new SpinnerNumberModel(10, 2, 1000, 1);
    private SpinnerNumberModel trainningTimeSpinnerModel = new SpinnerNumberModel(400, 1, 10000, 1);
    private SpinnerNumberModel minimumErrorVariationSpinnerModel = new SpinnerNumberModel(0.1, 1.0E-5, 1.0, 0.001);
    private SpinnerNumberModel activationFunctionSteepSpinnerModel = new SpinnerNumberModel(1.0, 0.1, 2.0, 0.1);
    private boolean learningRateDecay = false;
    private int numericalInputNormalization = 0;
    private boolean autoHiddenLayerSize = true;
    private int hiddenLayerSize = 10;
    private int trainningTime = 400;
    private boolean minimumError = false;
    private double minimumErrorVariation = 0.1;
    private double activationFunctionSteep = 1.0;
    private boolean defaultLearningRateDecay = false;
    private boolean defaultNumericalInputNormalization = false;
    private boolean defaultAutoHiddenLayerSize = true;
    private int defaultHiddenLayerSize = 10;
    private int defaultTrainningTime = 400;
    private boolean defaultMinimumError = false;
    private double defaultMinimumErrorVariation = 0.1;
    private double defaultActivationFunctionSteep = 1.0;
    private Border border1;
    private TitledBorder titledBorder1;
    private Border border2;
    private TitledBorder titledBorder2;
    private Border border3;
    private TitledBorder titledBorder3;
    private Border border4;
    private TitledBorder titledBorder4;
    private Border border5;
    private TitledBorder titledBorder5;
    private JCheckBox errorVariationCheckBox = new JCheckBox();
    private JPanel inputNormalizationPanel = new JPanel();
    private BorderLayout borderLayout8 = new BorderLayout();
    private JCheckBox normalizationCheckBox = new JCheckBox();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel normalizationPanel = new JPanel();
    private Border border6;
    private TitledBorder titledBorder6;
    private BorderLayout borderLayout9 = new BorderLayout();
    private JPanel jPanel6 = new JPanel();
    private GridLayout gridLayout1 = new GridLayout();
    private JRadioButton radioLinearNormalization = new JRadioButton();
    private JRadioButton radioMean0SD1 = new JRadioButton();
    private ButtonGroup normalizationGroup = new ButtonGroup();

    public AdvancedOptionsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.neuralnetwork.resources.NeuralNetworkResource");
        this.fuctionSteepSpinner.setModel(this.activationFunctionSteepSpinnerModel);
        this.errorVariationSpinner.setModel(this.minimumErrorVariationSpinnerModel);
        this.trainningTimeSpinner.setModel(this.trainningTimeSpinnerModel);
        this.hiddenSizeSpinner.setModel(this.hiddenLayerSizeSpinnerModel);
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, this.resource.getString("learningRateLabel"));
        this.titledBorder1.setTitleFont(new Font("Dialog", 0, 12));
        this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border2, this.resource.getString("hiddenLayerSize"));
        this.titledBorder2.setTitleFont(new Font("Dialog", 0, 12));
        this.border3 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder3 = new TitledBorder(this.border3, this.resource.getString("activationFunctionSteep"));
        this.titledBorder3.setTitleFont(new Font("Dialog", 0, 12));
        this.border4 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder4 = new TitledBorder(this.border4, this.resource.getString("learningStopCondition"));
        this.titledBorder4.setTitleFont(new Font("Dialog", 0, 12));
        this.border5 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder5 = new TitledBorder(this.border5, this.resource.getString("numericInput"));
        this.titledBorder5.setTitleFont(new Font("Dialog", 0, 12));
        this.border6 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder6 = new TitledBorder(this.border6, this.resource.getString("normalizationAlgorithm"));
        this.titledBorder6.setTitleFont(new Font("Dialog", 0, 12));
        this.setLayout(this.borderLayout1);
        this.advancedOptions.setLayout(this.gridBagLayout1);
        this.learningRatePanel.setLayout(this.borderLayout2);
        this.learningRatePanel.setBorder(this.titledBorder1);
        this.learningRateCheckBox.setFont(new Font("Dialog", 0, 12));
        this.learningRateCheckBox.setText(this.resource.getString("learningRateDecay"));
        this.hiddenLayerPanel.setLayout(this.borderLayout3);
        this.hiddenLayerPanel.setBorder(this.titledBorder2);
        this.jPanel1.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(2);
        this.jPanel2.setLayout(this.borderLayout4);
        this.jPanel3.setLayout(this.borderLayout5);
        this.hiddenLayerCheckBox.setFont(new Font("Dialog", 0, 12));
        this.hiddenLayerCheckBox.setText(this.resource.getString("auto"));
        this.hiddenLayerCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsPanel.this.hiddenLayerCheckBox_actionPerformed(e);
            }
        });
        this.hiddenSizeSpinner.setBorder(null);
        this.hiddenSizeSpinner.setEnabled(false);
        this.trainningTimePanel.setLayout(this.borderLayout6);
        this.jPanel4.setLayout(this.gridLayout3);
        this.gridLayout3.setRows(4);
        this.labelTimeLimit.setFont(new Font("Dialog", 0, 12));
        this.labelTimeLimit.setText(String.valueOf(this.resource.getString("limitOfEpochs")) + ":");
        this.activationFunctionSteepPanel.setBorder(this.titledBorder3);
        this.activationFunctionSteepPanel.setLayout(this.borderLayout7);
        this.trainningTimePanel.setBorder(this.titledBorder4);
        this.trainningTimePanel.setDebugGraphicsOptions(0);
        this.trainningTimeSpinner.setBorder(null);
        this.errorVariationSpinner.setBorder(null);
        this.errorVariationSpinner.setEnabled(false);
        this.fuctionSteepSpinner.setBorder(null);
        this.errorVariationCheckBox.setFont(new Font("Dialog", 0, 12));
        this.errorVariationCheckBox.setText(this.resource.getString("relativeError"));
        this.errorVariationCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsPanel.this.errorVariationCheckBox_actionPerformed(e);
            }
        });
        this.inputNormalizationPanel.setLayout(this.borderLayout8);
        this.inputNormalizationPanel.setBorder(this.titledBorder5);
        this.normalizationCheckBox.setFont(new Font("Dialog", 0, 12));
        this.normalizationCheckBox.setText(this.resource.getString("normalizeNumericInput"));
        this.normalizationCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsPanel.this.normalizationCheckBox_actionPerformed(e);
            }
        });
        this.normalizationPanel.setBorder(this.titledBorder6);
        this.normalizationPanel.setLayout(this.borderLayout9);
        this.jPanel6.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(2);
        this.radioLinearNormalization.setEnabled(false);
        this.radioLinearNormalization.setFont(new Font("Dialog", 0, 12));
        this.radioLinearNormalization.setSelectedIcon(null);
        this.radioLinearNormalization.setText(this.resource.getString("linearNormalization"));
        this.radioMean0SD1.setEnabled(false);
        this.radioMean0SD1.setFont(new Font("Dialog", 0, 12));
        this.radioMean0SD1.setText(this.resource.getString("mean0StandardDeviation1"));
        this.jPanel1.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.hiddenLayerCheckBox, "Center");
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.hiddenSizeSpinner, "Center");
        this.trainningTimePanel.add((Component)this.jPanel4, "Center");
        this.activationFunctionSteepPanel.add((Component)this.fuctionSteepSpinner, "Center");
        this.hiddenLayerPanel.add((Component)this.jPanel1, "Center");
        this.learningRatePanel.add((Component)this.learningRateCheckBox, "Center");
        this.add((Component)this.advancedOptions, "Center");
        this.jPanel4.add((Component)this.labelTimeLimit, null);
        this.jPanel4.add((Component)this.trainningTimeSpinner, null);
        this.jPanel4.add((Component)this.errorVariationCheckBox, null);
        this.jPanel4.add((Component)this.errorVariationSpinner, null);
        this.advancedOptions.add((Component)this.learningRatePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 127, 0));
        this.advancedOptions.add((Component)this.inputNormalizationPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 107, 0));
        this.advancedOptions.add((Component)this.hiddenLayerPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 193, 0));
        this.advancedOptions.add((Component)this.trainningTimePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 7, 0));
        this.advancedOptions.add((Component)this.activationFunctionSteepPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 2, 0), 237, 0));
        this.inputNormalizationPanel.add((Component)this.normalizationCheckBox, "North");
        this.inputNormalizationPanel.add((Component)this.normalizationPanel, "Center");
        this.normalizationPanel.add((Component)this.jPanel6, "Center");
        this.jPanel6.add((Component)this.radioLinearNormalization, null);
        this.jPanel6.add((Component)this.radioMean0SD1, null);
        this.startDefaultValues();
        this.normalizationGroup.add(this.radioLinearNormalization);
        this.normalizationGroup.add(this.radioMean0SD1);
    }

    public void updateValues() {
        this.learningRateDecay = this.learningRateCheckBox.isSelected();
        this.numericalInputNormalization = this.normalizationCheckBox.isSelected() ? (this.radioLinearNormalization.isSelected() ? 1 : 2) : 0;
        this.autoHiddenLayerSize = this.hiddenLayerCheckBox.isSelected();
        this.hiddenLayerSize = Integer.parseInt(this.hiddenSizeSpinner.getValue().toString());
        this.trainningTime = Integer.parseInt(this.trainningTimeSpinner.getValue().toString());
        this.minimumError = this.errorVariationCheckBox.isSelected();
        this.minimumErrorVariation = Double.parseDouble(this.errorVariationSpinner.getValue().toString());
        this.activationFunctionSteep = Double.parseDouble(this.fuctionSteepSpinner.getValue().toString());
    }

    public void startDefaultValues() {
        this.learningRateCheckBox.setSelected(this.defaultLearningRateDecay);
        this.normalizationCheckBox.setSelected(this.defaultNumericalInputNormalization);
        this.radioLinearNormalization.setSelected(true);
        this.hiddenLayerCheckBox.setSelected(this.defaultAutoHiddenLayerSize);
        this.hiddenSizeSpinner.setValue(new Integer(this.defaultHiddenLayerSize));
        this.trainningTimeSpinner.setValue(new Integer(this.defaultTrainningTime));
        this.errorVariationCheckBox.setSelected(this.defaultMinimumError);
        this.errorVariationSpinner.setValue(new Double(this.defaultMinimumErrorVariation));
        this.fuctionSteepSpinner.setValue(new Double(this.defaultActivationFunctionSteep));
    }

    public void sethiddenLayerSize(int hiddenLayerSize) {
        this.hiddenLayerSize = hiddenLayerSize;
        this.defaultHiddenLayerSize = hiddenLayerSize;
        this.hiddenSizeSpinner.setValue(new Integer(hiddenLayerSize));
    }

    public boolean getLearningRateDecayEnabled() {
        return this.learningRateDecay;
    }

    public int getNumericalInputNormalization() {
        return this.numericalInputNormalization;
    }

    public int getHiddenLayerSize() {
        if (this.hiddenLayerCheckBox.isSelected()) {
            return -1;
        }
        return this.hiddenLayerSize;
    }

    public int getTrainningTime() {
        return this.trainningTime;
    }

    public double getMinimumErrorVariation() {
        if (this.errorVariationCheckBox.isSelected()) {
            return this.minimumErrorVariation;
        }
        return -2.0;
    }

    public double getActivationFunctionSteep() {
        return this.activationFunctionSteep;
    }

    void hiddenLayerCheckBox_actionPerformed(ActionEvent e) {
        this.hiddenSizeSpinner.setEnabled(!this.hiddenLayerCheckBox.isSelected());
        this.hiddenSizeSpinner.setValue(new Integer(this.defaultHiddenLayerSize));
    }

    void errorVariationCheckBox_actionPerformed(ActionEvent e) {
        this.errorVariationSpinner.setEnabled(this.errorVariationCheckBox.isSelected());
    }

    void normalizationCheckBox_actionPerformed(ActionEvent e) {
        this.radioLinearNormalization.setEnabled(this.normalizationCheckBox.isSelected());
        this.radioMean0SD1.setEnabled(this.normalizationCheckBox.isSelected());
    }
}

