/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.neuralmodel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.IconController;
import unbbayes.datamining.gui.AttributePanel;
import unbbayes.datamining.gui.neuralmodel.InferencePanel;
import unbbayes.datamining.gui.neuralmodel.NeuralModelController;
import unbbayes.datamining.gui.neuralmodel.OptionsPanel;
import unbbayes.datamining.gui.neuralmodel.RulesPanel;

public class NeuralModelMain
extends JInternalFrame {
    private static final long serialVersionUID = 0L;
    private JPanel contentPane;
    private BorderLayout borderLayout1 = new BorderLayout();
    private ResourceBundle resource;
    private JToolBar jToolBar1 = new JToolBar();
    private JButton helpButton = new JButton();
    private JButton learnButton = new JButton();
    private JButton saveButton = new JButton();
    private JButton openButton = new JButton();
    private ImageIcon openIcon;
    private ImageIcon openModelIcon;
    private ImageIcon compileIcon;
    private ImageIcon helpIcon;
    private ImageIcon saveIcon;
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private BorderLayout borderLayout3 = new BorderLayout();
    private BorderLayout borderLayout4 = new BorderLayout();
    private BorderLayout borderLayout6 = new BorderLayout();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private JPanel tabbedPaneAttributes = new JPanel();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JLabel statusBar = new JLabel();
    private Border border1;
    private TitledBorder titledBorder1;
    private BorderLayout borderLayout2 = new BorderLayout();
    private BorderLayout borderLayout7 = new BorderLayout();
    private JPanel panelOptions = new JPanel();
    private BorderLayout borderLayout8 = new BorderLayout();
    private JPanel tabbedPanelClassify = new JPanel();
    private BorderLayout borderLayout11 = new BorderLayout();
    private JLabel jLabel1 = new JLabel();
    private JButton openModelButton = new JButton();
    private NeuralModelController controller = null;
    protected OptionsPanel optionsPanel;
    protected JPanel tabbedPaneRules = new JPanel();
    protected AttributePanel attributePanel;
    protected RulesPanel rulesPanel;
    protected InferencePanel inferencePanel = new InferencePanel();
    protected IconController iconController = IconController.getInstance();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem openMenu = new JMenuItem();
    JMenuItem openModelMenu = new JMenuItem();
    JMenuItem saveModelMenu = new JMenuItem();
    JMenuItem exitMenu = new JMenuItem();
    JMenu learnMenu = new JMenu();
    JMenuItem learnModelMenu = new JMenuItem();
    JMenu helpMenu = new JMenu();
    JMenuItem helpTopicsMenu = new JMenuItem();
    JLabel jLabel2 = new JLabel();

    public NeuralModelMain(NeuralModelController controller) {
        super("Combinatorial Neural Model", true, true, true, true);
        this.controller = controller;
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.neuralmodel.resources.NeuralModelResource");
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.openIcon = this.iconController.getOpenIcon();
        this.openModelIcon = this.iconController.getOpenModelIcon();
        this.compileIcon = this.iconController.getCompileIcon();
        this.helpIcon = this.iconController.getHelpIcon();
        this.saveIcon = this.iconController.getSaveIcon();
        this.contentPane = (JPanel)this.getContentPane();
        this.titledBorder1 = new TitledBorder(this.border1, "Status");
        this.setSize(new Dimension(640, 521));
        this.openButton.setToolTipText(this.resource.getString("openFileToolTip"));
        this.openButton.setIcon(this.openIcon);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.open_actionPerformed(e);
            }
        });
        this.saveButton.setEnabled(false);
        this.saveButton.setToolTipText(this.resource.getString("saveModelToolTip"));
        this.saveButton.setIcon(this.saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.save_actionPerformed(e);
            }
        });
        this.learnButton.setEnabled(false);
        this.learnButton.setToolTipText(this.resource.getString("learnDataTooltip"));
        this.learnButton.setIcon(this.compileIcon);
        this.learnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.learn_actionPerformed(e);
            }
        });
        this.helpButton.setToolTipText(this.resource.getString("helpFileTooltip"));
        this.helpButton.setIcon(this.helpIcon);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.help_actionPerformed(e);
            }
        });
        this.openModelButton.setToolTipText(this.resource.getString("openModelToolTip"));
        this.openModelButton.setIcon(this.openModelIcon);
        this.openModelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.openModel_actionPerformed(e);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jPanel2.setLayout(this.borderLayout5);
        this.jPanel3.setLayout(this.borderLayout6);
        this.statusBar.setText(this.resource.getString("welcome"));
        this.jPanel2.setBorder(this.titledBorder1);
        this.tabbedPaneRules.setLayout(this.borderLayout2);
        this.tabbedPaneAttributes.setLayout(this.borderLayout7);
        this.panelOptions.setLayout(this.borderLayout8);
        this.optionsPanel = new OptionsPanel();
        this.tabbedPanelClassify.setLayout(this.borderLayout11);
        this.fileMenu.setText(this.resource.getString("fileMenu"));
        this.openMenu.setText(this.resource.getString("openMenu"));
        this.openMenu.setIcon(this.openIcon);
        this.openMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.open_actionPerformed(e);
            }
        });
        this.openModelMenu.setText(this.resource.getString("openModelMenu"));
        this.openModelMenu.setIcon(this.openModelIcon);
        this.openModelMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.openModel_actionPerformed(e);
            }
        });
        this.saveModelMenu.setText(this.resource.getString("saveModelMenu"));
        this.saveModelMenu.setEnabled(false);
        this.saveModelMenu.setFocusPainted(false);
        this.saveModelMenu.setIcon(this.saveIcon);
        this.saveModelMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.save_actionPerformed(e);
            }
        });
        this.exitMenu.setText(this.resource.getString("exitMenu"));
        this.exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.exitMenu_actionPerformed(e);
            }
        });
        this.learnMenu.setEnabled(false);
        this.learnMenu.setText(this.resource.getString("learnMenu"));
        this.learnModelMenu.setText(this.resource.getString("learnModelMenu"));
        this.learnModelMenu.setIcon(this.compileIcon);
        this.learnModelMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.learn_actionPerformed(e);
            }
        });
        this.helpMenu.setText(this.resource.getString("helpMenu"));
        this.helpTopicsMenu.setText(this.resource.getString("helpTopicsMenu"));
        this.helpTopicsMenu.setIcon(this.helpIcon);
        this.helpTopicsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NeuralModelMain.this.help_actionPerformed(e);
            }
        });
        this.jLabel1.setToolTipText("");
        this.jLabel2.setText("   ");
        this.jLabel1.setText("   ");
        this.jToolBar1.add((Component)this.openButton, null);
        this.jToolBar1.add((Component)this.learnButton, null);
        this.jToolBar1.add((Component)this.jLabel1, null);
        this.jToolBar1.add((Component)this.openModelButton, null);
        this.jToolBar1.add((Component)this.saveButton, null);
        this.jToolBar1.add((Component)this.jLabel2, null);
        this.jToolBar1.add((Component)this.helpButton, null);
        this.contentPane.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jTabbedPane1, "Center");
        this.attributePanel = new AttributePanel();
        this.tabbedPaneAttributes.add((Component)this.attributePanel, "Center");
        this.jTabbedPane1.add((Component)this.tabbedPaneAttributes, this.resource.getString("tabbedPaneAttributes"));
        this.jTabbedPane1.add((Component)this.tabbedPaneRules, this.resource.getString("tabbedPaneRules"));
        this.jTabbedPane1.add((Component)this.tabbedPanelClassify, this.resource.getString("tabbedPanelClassify"));
        this.tabbedPanelClassify.add(this.inferencePanel);
        this.rulesPanel = new RulesPanel(this.controller);
        this.tabbedPaneRules.add((Component)this.rulesPanel, "Center");
        this.contentPane.add((Component)this.jPanel2, "South");
        this.setJMenuBar(this.jMenuBar1);
        this.jPanel2.add((Component)this.statusBar, "Center");
        this.contentPane.add((Component)this.jToolBar1, "North");
        this.panelOptions.add((Component)this.optionsPanel, "Center");
        this.tabbedPaneAttributes.add((Component)this.panelOptions, "South");
        this.jMenuBar1.add(this.fileMenu);
        this.jMenuBar1.add(this.learnMenu);
        this.jMenuBar1.add(this.helpMenu);
        this.fileMenu.add(this.openMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openModelMenu);
        this.fileMenu.add(this.saveModelMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenu);
        this.learnMenu.add(this.learnModelMenu);
        this.helpMenu.add(this.helpTopicsMenu);
        this.jTabbedPane1.setEnabledAt(0, false);
        this.jTabbedPane1.setEnabledAt(1, false);
        this.jTabbedPane1.setEnabledAt(2, false);
    }

    public void setController(NeuralModelController controller) {
        this.controller = controller;
    }

    void help_actionPerformed(ActionEvent e) {
        try {
            this.controller.help();
        }
        catch (Exception evt) {
            this.statusBar.setText("Error = " + evt.getMessage() + " " + this.getClass().getName());
        }
    }

    void learn_actionPerformed(ActionEvent e) {
        try {
            this.controller.learn();
        }
        catch (Exception ex) {
            this.statusBar.setText(String.valueOf(this.resource.getString("exception")) + " " + ex.getMessage());
        }
        this.jTabbedPane1.setEnabledAt(1, true);
        this.jTabbedPane1.setEnabledAt(2, true);
        this.jTabbedPane1.setSelectedIndex(1);
        this.saveButton.setEnabled(true);
        this.saveModelMenu.setEnabled(true);
    }

    void open_actionPerformed(ActionEvent e) {
        try {
            boolean success = this.controller.openFile();
            if (success) {
                this.jTabbedPane1.setEnabledAt(0, false);
                this.optionsPanel.enableCombos(true);
                this.jTabbedPane1.setEnabledAt(0, true);
                this.jTabbedPane1.setSelectedIndex(0);
                this.jTabbedPane1.setEnabledAt(1, false);
                this.jTabbedPane1.setEnabledAt(2, false);
                this.learnButton.setEnabled(true);
                this.learnMenu.setEnabled(true);
                this.saveButton.setEnabled(false);
                this.saveModelMenu.setEnabled(false);
                this.statusBar.setText(this.resource.getString("openFile"));
            }
        }
        catch (NullPointerException npe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorDB")) + " " + npe.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("fileNotFound")) + " " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorOpen")) + " " + ioe.getMessage());
        }
        catch (Exception ex) {
            this.statusBar.setText(String.valueOf(this.resource.getString("error")) + ex.getMessage());
        }
    }

    void save_actionPerformed(ActionEvent e) {
        try {
            boolean success = this.controller.saveModel();
            if (success) {
                this.statusBar.setText(this.resource.getString("saveModel"));
            }
        }
        catch (Exception ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorWritingFileException")) + " " + ioe.getMessage());
        }
    }

    void openModel_actionPerformed(ActionEvent e) {
        try {
            boolean success = this.controller.openModel();
            if (success) {
                this.jTabbedPane1.setEnabledAt(0, false);
                this.jTabbedPane1.setEnabledAt(1, true);
                this.jTabbedPane1.setEnabledAt(2, true);
                this.learnButton.setEnabled(false);
                this.learnMenu.setEnabled(false);
                this.saveButton.setEnabled(false);
                this.saveModelMenu.setEnabled(false);
                this.statusBar.setText(this.resource.getString("modelOpenedSuccessfully"));
                this.jTabbedPane1.setSelectedIndex(1);
            }
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorWritingFileException")) + " " + ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            this.statusBar.setText(cnfe.getMessage());
        }
    }

    void exitMenu_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

