/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.neuralmodel;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import unbbayes.controller.FileController;
import unbbayes.controller.JavaHelperController;
import unbbayes.controller.PrintMonitor;
import unbbayes.controller.PrintPreviewer;
import unbbayes.controller.PrintTable;
import unbbayes.datamining.classifiers.CombinatorialNeuralModel;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.gui.neuralmodel.NeuralModelMain;
import unbbayes.datamining.gui.neuralmodel.RulesPanel;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;

public class NeuralModelController {
    private CombinatorialNeuralModel cnm = null;
    private NeuralModelMain mainScreen;
    private JFileChooser fileChooser;
    private InstanceSet instanceSet;
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.gui.neuralmodel.resources.NeuralModelResource");
    private File file;

    public NeuralModelController() {
        this.mainScreen = new NeuralModelMain(this);
        this.mainScreen.setController(this);
    }

    public JInternalFrame getCnmFrame() {
        return this.mainScreen;
    }

    protected boolean openFile() throws Exception {
        this.mainScreen.setCursor(new Cursor(3));
        String[] arff = new String[]{"ARFF"};
        String[] txt = new String[]{"TXT"};
        boolean fileOpenSuccess = false;
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setDialogTitle(this.resource.getString("openFile2"));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this.mainScreen));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(txt, "TxtFiles (*.txt)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(arff, "ArffFiles (*.arff)"));
        int returnValue = this.fileChooser.showOpenDialog(this.mainScreen);
        if (returnValue == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.openFile(selectedFile);
            this.file = selectedFile;
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
            fileOpenSuccess = true;
        }
        this.mainScreen.setCursor(new Cursor(0));
        return fileOpenSuccess;
    }

    private void openFile(File selectedFile) throws Exception {
        this.instanceSet = FileController.getInstance().getInstanceSet(selectedFile, this.mainScreen);
        boolean numericAttributes = this.instanceSet.checkNumericAttributes();
        if (numericAttributes) {
            throw new Exception(this.resource.getString("numericAttributesException"));
        }
        this.mainScreen.setTitle("CNM - " + selectedFile.getName());
        this.mainScreen.attributePanel.setInstances(this.instanceSet);
        this.mainScreen.attributePanel.enableComboBox(true);
    }

    public boolean saveModel() throws Exception {
        this.mainScreen.setCursor(new Cursor(3));
        String[] cnmString = new String[]{"cnm"};
        boolean success = false;
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setDialogTitle(this.resource.getString("saveModel2"));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this.mainScreen));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(cnmString, "Modelo Neural Combinat\ufffdrio (*.cnm)"));
        int returnVal = this.fileChooser.showSaveDialog(this.mainScreen);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            String fileName = selectedFile.getName();
            if (!fileName.regionMatches(true, fileName.length() - 4, ".cnm", 0, 4)) {
                selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + ".cnm");
            }
            this.modelPrunnig();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(selectedFile));
            out.writeObject(this.cnm);
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
            success = true;
        }
        this.mainScreen.setCursor(new Cursor(0));
        return success;
    }

    private void modelPrunnig() {
        int minSupport = this.mainScreen.rulesPanel.getSupport();
        int minConfidence = this.mainScreen.rulesPanel.getConfidence();
        this.cnm.prunning(minSupport, minConfidence);
    }

    public boolean openModel() throws IOException, ClassNotFoundException {
        this.mainScreen.setCursor(new Cursor(3));
        String[] cnmString = new String[]{"cnm"};
        boolean success = false;
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setDialogTitle(this.resource.getString("openModel2"));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this.mainScreen));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(cnmString, "Modelo Neural Combinat\ufffdri (*.cnm)"));
        int returnVal = this.fileChooser.showOpenDialog(this.mainScreen);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(selectedFile));
            this.cnm = null;
            this.cnm = (CombinatorialNeuralModel)in.readObject();
            this.mainScreen.tabbedPaneRules.removeAll();
            this.mainScreen.rulesPanel = new RulesPanel(this);
            this.mainScreen.rulesPanel.setRulesPanel(this.cnm, this.cnm.getConfidence(), this.cnm.getSupport());
            this.mainScreen.tabbedPaneRules.add((Component)this.mainScreen.rulesPanel, "Center");
            this.mainScreen.inferencePanel.setNetwork(this.cnm);
            this.mainScreen.setTitle("CNM - " + this.resource.getString("model") + " " + selectedFile.getName());
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
            this.file = selectedFile;
            success = true;
        }
        this.mainScreen.setCursor(new Cursor(0));
        return success;
    }

    public void help() throws Exception {
        JavaHelperController.getInstance().openHelp(this.mainScreen);
    }

    public void learn() throws Exception {
        this.mainScreen.setCursor(new Cursor(3));
        if (this.instanceSet != null) {
            int maxOrder = this.mainScreen.optionsPanel.getMaxOrder();
            int confidence = this.mainScreen.optionsPanel.getConfidence();
            int support = this.mainScreen.optionsPanel.getSupport();
            this.cnm = new CombinatorialNeuralModel(maxOrder);
            this.cnm.buildClassifier(this.instanceSet);
            this.mainScreen.rulesPanel.setRulesPanel(this.cnm, confidence, support);
            this.mainScreen.inferencePanel.setNetwork(this.cnm);
        }
        this.mainScreen.setCursor(new Cursor(0));
    }

    public void printTable(final JTable table) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                ArrayList<JTable> tables = new ArrayList<JTable>();
                tables.add(table);
                PageFormat pageFormat = new PageFormat();
                pageFormat.setOrientation(0);
                PrintTable printTable = new PrintTable(tables, NeuralModelController.this.file.getName().toUpperCase(), pageFormat);
                PrintMonitor printMonitor = new PrintMonitor(printTable);
                try {
                    printMonitor.performPrint(true);
                }
                catch (PrinterException pe) {
                    JOptionPane.showMessageDialog(NeuralModelController.this.mainScreen, String.valueOf(NeuralModelController.this.resource.getString("printException")) + pe.getMessage());
                }
            }
        });
        t.start();
    }

    public void printPreviewer(final JTable table) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                ArrayList<JTable> tables = new ArrayList<JTable>();
                tables.add(table);
                PageFormat pageFormat = new PageFormat();
                pageFormat.setOrientation(0);
                PrintTable printTable = new PrintTable(tables, NeuralModelController.this.file.getName().toUpperCase(), pageFormat);
                PrintPreviewer printPreviewer = new PrintPreviewer(printTable, 0);
                JDialog dlg = new JDialog();
                dlg.getContentPane().add(printPreviewer);
                dlg.setSize(400, 300);
                dlg.setVisible(true);
            }
        });
        t.start();
    }
}

