/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.c45;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import unbbayes.datamining.classifiers.decisiontree.C45;
import unbbayes.datamining.classifiers.decisiontree.Leaf;
import unbbayes.datamining.classifiers.decisiontree.Node;
import unbbayes.datamining.classifiers.decisiontree.NominalNode;
import unbbayes.datamining.classifiers.decisiontree.NumericNode;
import unbbayes.datamining.classifiers.decisiontree.SplitObject;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.NumericData;
import unbbayes.datamining.datamanipulation.Options;
import unbbayes.datamining.datamanipulation.Utils;

public class VerbosityPanel
extends JScrollPane {
    private static final long serialVersionUID = 0L;
    private JTextArea textArea = new JTextArea();

    public VerbosityPanel() {
        this.getViewport().add((Component)this.textArea, null);
        this.textArea.setEditable(false);
    }

    public void writeVerbosityText(C45 c45, InstanceSet data) {
        int verbosityLevel = Options.getInstance().getVerbosityLevel();
        boolean prunned = Options.getInstance().getIfUsingPrunning();
        Node node = c45.getInfoRootNode();
        Stack<Node> stack = new Stack<Node>();
        stack.add(node);
        InstanceSet instances = data;
        Attribute[] attributes = instances.getAttributes();
        Attribute classAttribute = instances.getClassAttribute();
        String[] classValues = classAttribute.getDistinticNominalValues();
        int classSize = classValues.length;
        StringBuffer text = new StringBuffer();
        text.append("DECISION TREE:");
        text.append(c45.toString());
        if (prunned) {
            text.append("\n\nDECISION TREE BEFORE PRUNNING:");
            text.append(String.valueOf(c45.getStringInfoTree()) + "\n");
        }
        text.append("\nTOTAL: " + instances.numWeightedInstances() + " instances\n");
        if (verbosityLevel > 1) {
            text.append("\nSPLIT DETAILS:\n");
        }
        while (!stack.empty()) {
            int i;
            node = (Node)stack.pop();
            ArrayList children = node.getChildren();
            if (children.get(0) instanceof Leaf) continue;
            if (verbosityLevel > 1) {
                double cut;
                Instance instance;
                double[] infoGains = node.getInfoGains();
                SplitObject splitData = node.getSplitData();
                Integer[] attIndexes = splitData.getAttributes();
                ArrayList instIndexes = splitData.getInstances();
                ArrayList numericDataList = node.getNumericDataList();
                int treeLevel = attributes.length - attIndexes.length;
                String space = "";
                i = 0;
                while (i < treeLevel) {
                    space = String.valueOf(space) + "|\t";
                    ++i;
                }
                if (treeLevel > 0) {
                    text.append(String.valueOf(space) + node.toString().toUpperCase() + "\n");
                }
                float numInstances = 0.0f;
                i = 0;
                while (i < instIndexes.size()) {
                    instance = instIndexes.get(i) instanceof Integer ? instances.getInstance((Integer)instIndexes.get(i)) : (Instance)instIndexes.get(i);
                    numInstances += instance.getWeight();
                    ++i;
                }
                text.append(String.valueOf(space) + Utils.keep2DigitsAfterDot(numInstances) + " instances\n");
                if (verbosityLevel > 2) {
                    i = 0;
                    int j = 0;
                    int k = 0;
                    while (i < infoGains.length) {
                        int x;
                        NumericData numericData;
                        Attribute attribute = attributes[attIndexes[j]];
                        if (attribute.getIndex() == classAttribute.getIndex()) {
                            ++j;
                        }
                        text.append(String.valueOf(space) + "Attribute " + attribute.getAttributeName() + ": ");
                        if (attribute.isNumeric()) {
                            numericData = (NumericData)numericDataList.get(k);
                            cut = 0.0;
                            x = 0;
                            while (x < numericData.getNumberOfCuts()) {
                                if (infoGains[i] == numericData.getGain(x)) {
                                    cut = numericData.getCut(x);
                                    break;
                                }
                                ++x;
                            }
                            text.append("gain = " + infoGains[i] + ", cut = " + cut + ".\n");
                        } else {
                            text.append("gain = " + infoGains[i] + ".\n");
                        }
                        if (verbosityLevel > 3) {
                            int y;
                            if (attribute.isNominal()) {
                                float[][] distribution = new float[attribute.getDistinticNominalValues().length][classSize];
                                float[] missingDistribution = new float[classSize];
                                x = 0;
                                while (x < instIndexes.size()) {
                                    instance = instIndexes.get(x) instanceof Integer ? instances.getInstance((Integer)instIndexes.get(x)) : (Instance)instIndexes.get(x);
                                    if (instance.isMissing(attribute)) {
                                        int n = (int)instance.getValue(instance.getClassIndex());
                                        missingDistribution[n] = missingDistribution[n] + instance.getWeight();
                                    } else {
                                        float[] fArray = distribution[(int)instance.getValue(attribute)];
                                        int n = (int)instance.getValue(instance.getClassIndex());
                                        fArray[n] = fArray[n] + instance.getWeight();
                                    }
                                    ++x;
                                }
                                text.append(space);
                                x = 0;
                                while (x < classSize) {
                                    text.append("\t" + classValues[x]);
                                    ++x;
                                }
                                text.append("\n");
                                String[] attributeValues = attribute.getDistinticNominalValues();
                                x = 0;
                                while (x < attributeValues.length) {
                                    if (attributeValues[x].length() > 5) {
                                        text.append(String.valueOf(space) + "[" + attributeValues[x].substring(0, 4).toLowerCase() + ".:");
                                    } else {
                                        text.append(String.valueOf(space) + "[" + attributeValues[x].toLowerCase() + ":");
                                    }
                                    y = 0;
                                    while (y < classSize) {
                                        text.append("\t" + Utils.keep2DigitsAfterDot(distribution[x][y]));
                                        ++y;
                                    }
                                    text.append("]\n");
                                    ++x;
                                }
                                text.append(String.valueOf(space) + "[unkn.:");
                                x = 0;
                                while (x < classSize) {
                                    text.append("\t" + Utils.keep2DigitsAfterDot(missingDistribution[x]));
                                    ++x;
                                }
                                text.append("]\n");
                                text.append(space);
                            } else {
                                numericData = (NumericData)numericDataList.get(k);
                                x = 0;
                                while (x < numericData.getNumberOfCuts()) {
                                    text.append(space);
                                    y = 0;
                                    while (y < classSize) {
                                        text.append("\t" + classValues[y]);
                                        ++y;
                                    }
                                    text.append("\n");
                                    text.append(String.valueOf(space) + "[below:");
                                    y = 0;
                                    while (y < classSize) {
                                        text.append("\t" + Utils.keep2DigitsAfterDot(numericData.getInstancesBelow(x)[y]));
                                        ++y;
                                    }
                                    text.append("]\n");
                                    text.append(String.valueOf(space) + "[above:");
                                    y = 0;
                                    while (y < classSize) {
                                        text.append("\t" + Utils.keep2DigitsAfterDot(numericData.getInstancesAbove(x)[y]));
                                        ++y;
                                    }
                                    text.append("]\n");
                                    text.append(String.valueOf(space) + "[unkn.:");
                                    y = 0;
                                    while (y < classSize) {
                                        text.append("\t" + Utils.keep2DigitsAfterDot(numericData.getMissingValuesDistribution()[y]));
                                        ++y;
                                    }
                                    text.append("]\n");
                                    text.append(String.valueOf(space) + "cut: " + numericData.getCut(x) + ". gain: " + numericData.getGain(x) + "\n");
                                    ++x;
                                }
                            }
                            text.append("\n");
                        }
                        if (attribute.isNumeric()) {
                            ++k;
                        }
                        ++i;
                        ++j;
                    }
                }
                Node childNode = (Node)children.get(0);
                int attIndex = childNode.getAttribute().getIndex();
                int gainIndex = Utils.maxIndex(infoGains);
                if (childNode instanceof NominalNode) {
                    text.append(String.valueOf(space) + "Best attribute: " + childNode.getAttributeName() + "(gain = " + infoGains[gainIndex] + ")\n\n");
                } else {
                    NumericNode numericNode = (NumericNode)childNode;
                    cut = numericNode.getSplitValue();
                    text.append(String.valueOf(space) + "Best attribute: " + childNode.getAttributeName() + " (gain = " + infoGains[gainIndex] + ", cut = " + cut + ")\n\n");
                }
                if (verbosityLevel > 3) {
                    text.append("-------------------------------------------------\n\n");
                }
            }
            i = children.size() - 1;
            while (i >= 0) {
                stack.add((Node)children.get(i));
                --i;
            }
        }
        this.textArea.setText(text.toString());
        this.textArea.setCaretPosition(0);
    }
}

