/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.c45;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import unbbayes.controller.IconController;
import unbbayes.datamining.classifiers.decisiontree.C45;

public class InductionPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane jSplitPane = new JSplitPane();
    JPanel messagesPanel = new JPanel();
    JTree jTree = new JTree();
    JPanel leftSplitPanel = new JPanel();
    JPanel rightSplitPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel messageBodyPanel = new JPanel();
    JPanel messageTitlePanel = new JPanel();
    JLabel messageLabel = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea messageTextArea = new JTextArea();
    BorderLayout borderLayout3 = new BorderLayout();
    JScrollPane jScrollPane2 = new JScrollPane();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel nodetitlePanel = new JPanel();
    JLabel nodeLabel = new JLabel();
    ButtonGroup buttonGroup = new ButtonGroup();
    JScrollPane jScrollPane3 = new JScrollPane();
    JPanel nodePanel = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    TreeModel model;
    Object actualRoot;
    Object root;
    DefaultTreeModel defaultModel;
    JRadioButton jRadioButton;
    private static final int DONT_EXPAND = 0;
    private static final int EXPAND = 1;
    private int controller = 0;
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.gui.c45.resources.DecisiontreeResource");

    public InductionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.messagesPanel.setLayout(this.borderLayout2);
        this.messageLabel.setText(this.resource.getString("messages"));
        this.messageTitlePanel.setLayout(this.gridLayout1);
        this.messageBodyPanel.setLayout(this.borderLayout3);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setRows(5);
        this.leftSplitPanel.setLayout(this.borderLayout4);
        this.rightSplitPanel.setLayout(this.borderLayout5);
        this.nodeLabel.setToolTipText("");
        this.nodePanel.setLayout(this.gridLayout2);
        this.gridLayout2.setRows(5);
        this.add((Component)this.jSplitPane, "Center");
        this.jSplitPane.add((Component)this.leftSplitPanel, "top");
        this.leftSplitPanel.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane.add((Component)this.rightSplitPanel, "bottom");
        this.rightSplitPanel.add((Component)this.nodetitlePanel, "North");
        this.nodetitlePanel.add((Component)this.nodeLabel, null);
        this.rightSplitPanel.add((Component)this.jScrollPane3, "Center");
        this.jScrollPane3.getViewport().add((Component)this.nodePanel, null);
        this.add((Component)this.messagesPanel, "South");
        this.messagesPanel.add((Component)this.messageBodyPanel, "Center");
        this.messageBodyPanel.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.messageTextArea, null);
        this.messagesPanel.add((Component)this.messageTitlePanel, "North");
        this.messageTitlePanel.add((Component)this.messageLabel, null);
    }

    public void setInstances(C45 id3) {
        this.jTree = id3.getTree();
        this.expand(this.jTree);
        this.jTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                InductionPanel.this.jTree_treeWillExpand(e);
            }

            public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
                InductionPanel.this.jTree_treeWillCollapse(e);
            }
        });
        this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                InductionPanel.this.jTree_valueChanged(e);
            }
        });
        TreeSelectionModel tsm = this.jTree.getSelectionModel();
        tsm.setSelectionMode(1);
        this.jScrollPane2.getViewport().add((Component)this.jTree, null);
        this.model = this.jTree.getModel();
        this.actualRoot = this.model.getRoot();
        this.root = this.model.getRoot();
        this.defaultModel = new DefaultTreeModel((TreeNode)this.root);
        this.jTree.setSelectionRow(0);
    }

    private void createButtonGroup(Object root) {
        if (root != null) {
            this.nodeLabel.setText("" + root);
            this.messageTextArea.append(String.valueOf(this.resource.getString("selectedNode")) + root + ":\n");
            int num = this.model.getChildCount(root);
            this.nodePanel.removeAll();
            this.nodePanel.repaint();
            int i = 0;
            while (i < num) {
                Object filho = this.model.getChild(root, i);
                boolean bool = this.model.isLeaf(filho);
                if (bool) {
                    JLabel noFolha = new JLabel();
                    noFolha.setForeground(Color.red);
                    noFolha.setText("       " + filho);
                    this.nodePanel.add(noFolha);
                    this.messageTextArea.append(String.valueOf(this.resource.getString("leaf")) + filho + "\n");
                } else {
                    this.addButton("" + filho);
                }
                ++i;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.actualRoot;
            if (node.getParent() != null) {
                this.addButton(this.resource.getString("back"));
            }
        }
    }

    private void addButton(String buttonName) {
        this.jRadioButton = new JRadioButton(buttonName, false);
        this.jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InductionPanel.this.jRadioButton_actionPerformed(e);
            }
        });
        this.buttonGroup.add(this.jRadioButton);
        this.nodePanel.add(this.jRadioButton);
        if (buttonName.equals(this.resource.getString("back"))) {
            this.jRadioButton.setMnemonic(((Character)this.resource.getObject("backMnemonic")).charValue());
            try {
                this.jRadioButton.setIcon(IconController.getInstance().getReturnIcon());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void jRadioButton_actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.resource.getString("back"))) {
            this.messageTextArea.append(String.valueOf(this.resource.getString("return")) + this.actualRoot + "\n\n");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.actualRoot;
            this.actualRoot = node.getParent();
            if (node.getParent() != null) {
                this.controller = 1;
                Object[] nodes = this.defaultModel.getPathToRoot((TreeNode)this.actualRoot);
                TreePath path = new TreePath(nodes);
                this.jTree.expandPath(path);
                this.jTree.setSelectionPath(path);
                this.jTree.scrollPathToVisible(path);
                this.controller = 0;
            }
        } else {
            this.actualRoot = this.findUserObject(e.getActionCommand());
            this.messageTextArea.append("\t" + this.actualRoot + "\n\n");
            if (!((TreeNode)this.actualRoot).isLeaf()) {
                this.controller = 1;
                Object[] nodes = this.defaultModel.getPathToRoot((TreeNode)this.actualRoot);
                TreePath path = new TreePath(nodes);
                this.jTree.expandPath(path);
                this.jTree.setSelectionPath(path);
                this.jTree.scrollPathToVisible(path);
                this.controller = 0;
            }
        }
    }

    public Object findUserObject(String str) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.actualRoot;
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreeNode node = e.nextElement();
            if (!node.toString().equals(str)) continue;
            return node;
        }
        return null;
    }

    void jTree_treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
        if (this.controller == 0) {
            throw new ExpandVetoException(e);
        }
    }

    void jTree_treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        if (this.controller == 0) {
            throw new ExpandVetoException(e);
        }
    }

    private void expand(JTree arvore) {
        int i = 0;
        while (i < arvore.getRowCount()) {
            arvore.expandRow(i);
            ++i;
        }
    }

    void jTree_valueChanged(TreeSelectionEvent e) {
        this.controller = 0;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        int[] num = this.jTree.getSelectionRows();
        if (num[0] == 0) {
            this.messageTextArea.setText("");
        }
        this.actualRoot = node;
        this.createButtonGroup(this.actualRoot);
    }
}

