/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.bayesianlearning;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.JavaHelperController;
import unbbayes.datamining.classifiers.bayesianlearning.AlgorithmController;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.io.NetIO;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.exception.InvalidParentException;

public class BayesianLearningMain
extends JInternalFrame {
    private static final long serialVersionUID = 0L;
    private JPanel contentPane;
    private BorderLayout borderLayout1 = new BorderLayout();
    private InstanceSet inst;
    private ResourceBundle resource;
    private ProbabilisticNetwork net;
    private JToolBar jToolBar1 = new JToolBar();
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenu1 = new JMenu();
    private JMenuItem jMenuItem1 = new JMenuItem();
    private JMenuItem jMenuItem2 = new JMenuItem();
    private JMenu jMenu2 = new JMenu();
    private JMenuItem jMenuItem3 = new JMenuItem();
    private JMenu jMenu3 = new JMenu();
    private JMenuItem jMenuItem4 = new JMenuItem();
    private JMenuItem jMenuItem5 = new JMenuItem();
    private JButton helpButton = new JButton();
    private JButton learnButton = new JButton();
    private JButton saveButton = new JButton();
    private JButton openButton = new JButton();
    private ImageIcon abrirIcon;
    private ImageIcon compilaIcon;
    private ImageIcon helpIcon;
    private ImageIcon salvarIcon;
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private BorderLayout borderLayout3 = new BorderLayout();
    private BorderLayout borderLayout4 = new BorderLayout();
    private BorderLayout borderLayout6 = new BorderLayout();
    private JFileChooser fileChooser;
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JLabel statusBar = new JLabel();
    private Border border1;
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private TitledBorder titledBorder3;
    private TitledBorder titledBorder4;
    private TitledBorder titledBorder5;
    private JPanel jPanel4 = new JPanel();
    private JPanel jPanel1;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private BorderLayout borderLayout2 = new BorderLayout();
    private GridLayout gridLayout1 = new GridLayout();
    private JPanel jPanel5 = new JPanel();
    private JPanel jPanel6 = new JPanel();
    private GridLayout gridLayout2 = new GridLayout();
    private JPanel jPanel7 = new JPanel();
    private JPanel jPanel8 = new JPanel();
    private JPanel jPanel9 = new JPanel();
    private BorderLayout borderLayout7 = new BorderLayout();
    private JPanel jPanel10 = new JPanel();
    private GridLayout gridLayout3 = new GridLayout();
    private JPanel jPanel11 = new JPanel();
    private JPanel jPanel12 = new JPanel();
    private JPanel jPanel13 = new JPanel();
    private JPanel jPanel14 = new JPanel();
    private JPanel jPanel15 = new JPanel();
    private JPanel jPanel16 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private String[] metrics = new String[]{"GH"};
    private String[] paradigms = new String[]{"Ponctuation"};
    private String[] ponctuationAlgorithms = new String[]{"K2"};
    private JComboBox jComboBox1 = new JComboBox<String>(this.paradigms);
    private JComboBox jComboBox2 = new JComboBox<String>(this.ponctuationAlgorithms);
    private JComboBox jComboBox3 = new JComboBox<String>(this.metrics);

    public BayesianLearningMain() {
        super("Bayesian Learning", true, true, true, true);
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.naivebayes.resources.NaiveBayesResource");
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        IconController iconController = IconController.getInstance();
        this.abrirIcon = iconController.getOpenIcon();
        this.compilaIcon = iconController.getCompileIcon();
        this.helpIcon = iconController.getHelpIcon();
        this.salvarIcon = iconController.getSaveIcon();
        this.contentPane = (JPanel)this.getContentPane();
        this.titledBorder1 = new TitledBorder(this.border1, "Status");
        this.titledBorder2 = new TitledBorder(this.border1, "Main Settings");
        this.titledBorder3 = new TitledBorder(this.border1, "Ordenation");
        this.titledBorder4 = new TitledBorder(this.border1, "Relations");
        this.titledBorder5 = new TitledBorder(this.border1, "Threshold");
        this.jPanel1 = new JPanel();
        this.setJMenuBar(this.jMenuBar1);
        this.setSize(new Dimension(640, 480));
        this.jMenu1.setMnemonic(((Character)this.resource.getObject("fileMnemonic")).charValue());
        this.jMenu1.setText(this.resource.getString("fileMenu"));
        this.jMenuItem1.setIcon(this.abrirIcon);
        this.jMenuItem1.setMnemonic(((Character)this.resource.getObject("openMnemonic")).charValue());
        this.jMenuItem1.setText(this.resource.getString("openMenu"));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BayesianLearningMain.this.jMenuItem1_actionPerformed(e);
            }
        });
        this.jMenuItem2.setMnemonic(((Character)this.resource.getObject("exitMnemonic")).charValue());
        this.jMenuItem2.setText(this.resource.getString("exit"));
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BayesianLearningMain.this.jMenuItem2_actionPerformed(e);
            }
        });
        this.jMenu2.setMnemonic(((Character)this.resource.getObject("helpMnemonic")).charValue());
        this.jMenu2.setText(this.resource.getString("help"));
        this.jMenuItem3.setIcon(this.helpIcon);
        this.jMenuItem3.setMnemonic(((Character)this.resource.getObject("helpTopicsMnemonic")).charValue());
        this.jMenuItem3.setText(this.resource.getString("helpTopicsMenu"));
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BayesianLearningMain.this.jMenuItem3_actionPerformed(e);
            }
        });
        this.jMenu3.setMnemonic(((Character)this.resource.getObject("learningMnemonic")).charValue());
        this.jMenu3.setText(this.resource.getString("learningMenu"));
        this.jMenuItem4.setEnabled(false);
        this.jMenuItem4.setIcon(this.compilaIcon);
        this.jMenuItem4.setMnemonic(((Character)this.resource.getObject("learnNaiveBayesMnemonic")).charValue());
        this.jMenuItem4.setText(this.resource.getString("learnNaiveBayes"));
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BayesianLearningMain.this.jMenuItem4_actionPerformed(e);
            }
        });
        this.jMenuItem5.setEnabled(false);
        this.jMenuItem5.setIcon(this.salvarIcon);
        this.jMenuItem5.setMnemonic(((Character)this.resource.getObject("saveNetworkMnemonic")).charValue());
        this.jMenuItem5.setText(this.resource.getString("saveNetworkMenu"));
        this.jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BayesianLearningMain.this.jMenuItem5_actionPerformed(e);
            }
        });
        this.openButton.setToolTipText(this.resource.getString("openFileTooltip"));
        this.openButton.setIcon(this.abrirIcon);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BayesianLearningMain.this.openButton_actionPerformed(e);
            }
        });
        this.saveButton.setEnabled(false);
        this.saveButton.setToolTipText(this.resource.getString("saveFileTooltip"));
        this.saveButton.setIcon(this.salvarIcon);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BayesianLearningMain.this.saveButton_actionPerformed(e);
            }
        });
        this.learnButton.setEnabled(false);
        this.learnButton.setToolTipText(this.resource.getString("learnDataTooltip"));
        this.learnButton.setIcon(this.compilaIcon);
        this.learnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BayesianLearningMain.this.learnButton_actionPerformed(e);
            }
        });
        this.helpButton.setToolTipText(this.resource.getString("helpFileTooltip"));
        this.helpButton.setIcon(this.helpIcon);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BayesianLearningMain.this.helpButton_actionPerformed(e);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jPanel2.setLayout(this.borderLayout5);
        this.jPanel3.setLayout(this.borderLayout6);
        this.statusBar.setText(this.resource.getString("welcome"));
        this.jPanel2.setBorder(this.titledBorder1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel4.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.jPanel6.setLayout(this.gridLayout2);
        this.gridLayout2.setRows(2);
        this.jPanel7.setBorder(this.titledBorder3);
        this.jPanel7.setToolTipText("Use up and down arrows to move the field names so that a field does not depend on any of the fields below it.");
        this.jPanel8.setBorder(this.titledBorder4);
        this.jPanel8.setToolTipText("When field A is indirect cause of field B, select A from the first column and B from second column");
        this.jPanel5.setLayout(this.borderLayout7);
        this.jPanel9.setBorder(this.titledBorder2);
        this.jPanel9.setLayout(this.gridLayout3);
        this.jPanel10.setBorder(this.titledBorder5);
        this.gridLayout3.setColumns(2);
        this.gridLayout3.setRows(3);
        this.jLabel1.setText("Paradigm:");
        this.jLabel2.setText("Algorithm:");
        this.jLabel3.setText("Metric:");
        this.jComboBox1.setEnabled(false);
        this.jComboBox2.setEnabled(false);
        this.jComboBox3.setEnabled(false);
        this.contentPane.add((Component)this.jToolBar1, "North");
        this.jToolBar1.add((Component)this.openButton, null);
        this.jToolBar1.add((Component)this.saveButton, null);
        this.jToolBar1.add((Component)this.learnButton, null);
        this.jToolBar1.add((Component)this.helpButton, null);
        this.contentPane.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.jPanel4, "Settings");
        this.jPanel4.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.jPanel9, "Center");
        this.jPanel9.add((Component)this.jPanel16, null);
        this.jPanel16.add((Component)this.jLabel1, null);
        this.jPanel9.add((Component)this.jPanel15, null);
        this.jPanel15.add((Component)this.jComboBox1, null);
        this.jPanel9.add((Component)this.jPanel14, null);
        this.jPanel14.add((Component)this.jLabel2, null);
        this.jPanel9.add((Component)this.jPanel13, null);
        this.jPanel13.add((Component)this.jComboBox2, null);
        this.jPanel9.add((Component)this.jPanel12, null);
        this.jPanel12.add((Component)this.jLabel3, null);
        this.jPanel9.add((Component)this.jPanel11, null);
        this.jPanel11.add((Component)this.jComboBox3, null);
        this.jPanel5.add((Component)this.jPanel10, "South");
        this.jPanel4.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.jPanel7, null);
        this.jPanel6.add((Component)this.jPanel8, null);
        this.jTabbedPane1.add((Component)this.jScrollPane1, "Inference");
        this.jScrollPane1.getViewport().add((Component)this.jPanel1, null);
        this.contentPane.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.statusBar, "Center");
        this.jTabbedPane1.setEnabledAt(1, false);
        this.jTabbedPane1.setEnabledAt(0, false);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem5);
        this.jMenu1.add(this.jMenuItem2);
        this.jMenu2.add(this.jMenuItem3);
        this.jMenu3.add(this.jMenuItem4);
    }

    void jMenuItem3_actionPerformed(ActionEvent e) {
        try {
            JavaHelperController.getInstance().openHelp(this);
        }
        catch (Exception evt) {
            this.statusBar.setText("Error= " + evt.getMessage() + " " + this.getClass().getName());
        }
    }

    void jMenuItem4_actionPerformed(ActionEvent e) {
        try {
            AlgorithmController algorithmController = new AlgorithmController(this.inst, "" + this.jComboBox2.getSelectedItem(), "" + this.jComboBox3.getSelectedItem());
            this.jPanel1.removeAll();
            this.jPanel1.setLayout(new BorderLayout());
            this.jPanel1.add((Component)algorithmController.getNetWindow().getContentPane(), "Center");
            this.statusBar.setText("Estrutura Aprendida");
            this.jTabbedPane1.setEnabledAt(1, true);
            this.jTabbedPane1.setSelectedIndex(1);
            this.net = (ProbabilisticNetwork)algorithmController.getNetWindow().getSingleEntityNetwork();
            this.saveButton.setEnabled(true);
        }
        catch (InvalidParentException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage(), this.resource.getString("error"), 0);
        }
    }

    void jMenuItem2_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"ARFF"};
        String[] s2 = new String[]{"TXT"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "TxtFiles (*.txt)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "ArffFiles (*.arff)"));
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.openFile(selectedFile);
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    private void openFile(File selectedFile) {
        try {
            this.jTabbedPane1.setEnabledAt(0, false);
            this.inst = FileController.getInstance().getInstanceSet(selectedFile, this);
            if (this.inst != null) {
                boolean bool = this.inst.checkNumericAttributes();
                if (bool) {
                    throw new Exception(this.resource.getString("numericAttributesException"));
                }
                this.setTitle("Bayesian Learnning - " + selectedFile.getName());
                this.enableScreen();
            } else {
                this.statusBar.setText("Opera\ufffd\ufffdo cancelada");
            }
        }
        catch (NullPointerException npe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorDB")) + selectedFile.getName() + " " + npe.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("fileNotFound")) + selectedFile.getName() + " " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorOpen")) + selectedFile.getName() + " " + ioe.getMessage());
        }
        catch (Exception ex) {
            this.statusBar.setText(String.valueOf(this.resource.getString("error")) + ex.getMessage());
        }
    }

    private void enableScreen() {
        this.jTabbedPane1.setEnabledAt(0, true);
        this.jTabbedPane1.setSelectedIndex(0);
        this.jTabbedPane1.setEnabledAt(1, false);
        this.jMenuItem4.setEnabled(true);
        this.learnButton.setEnabled(true);
        this.jMenuItem5.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.jComboBox1.setEnabled(true);
        this.jComboBox2.setEnabled(true);
        this.jComboBox3.setEnabled(true);
        this.statusBar.setText(this.resource.getString("openFile"));
    }

    void jMenuItem5_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s2 = new String[]{"net"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "Networks (*.net)"));
        int returnVal = this.fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            try {
                String fileName = selectedFile.getName();
                if (!fileName.regionMatches(true, fileName.length() - 4, ".net", 0, 4)) {
                    selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + ".net");
                }
                NetIO io = new NetIO();
                io.save(selectedFile, this.net);
                this.statusBar.setText(this.resource.getString("saveModel"));
            }
            catch (Exception ioe) {
                this.statusBar.setText(String.valueOf(this.resource.getString("errorWritingFileException")) + selectedFile.getName() + " " + ioe.getMessage());
            }
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    void helpButton_actionPerformed(ActionEvent e) {
        this.jMenuItem3_actionPerformed(e);
    }

    void openButton_actionPerformed(ActionEvent e) {
        this.jMenuItem1_actionPerformed(e);
    }

    void saveButton_actionPerformed(ActionEvent e) {
        this.jMenuItem5_actionPerformed(e);
    }

    void learnButton_actionPerformed(ActionEvent e) {
        this.jMenuItem4_actionPerformed(e);
    }
}

