/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.layout.PlatformDefaults;

public class UtilsGUI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static boolean buttonOpaque = true;
    private static final Color LABEL_COLOR = new Color(0, 70, 213);

    public static JLabel createLabel(String text) {
        return UtilsGUI.createLabel(text, 10);
    }

    public static JLabel createLabel(String text, int align) {
        JLabel b = new JLabel(text, align);
        return b;
    }

    public static JComboBox createCombo(String[] items) {
        JComboBox<String> combo = new JComboBox<String>(items);
        if (PlatformDefaults.getCurrentPlatform() == 1) {
            combo.setOpaque(false);
        }
        return combo;
    }

    public static JTextField createTextField(int cols) {
        return UtilsGUI.createTextField("", cols);
    }

    public static JTextField createTextField(String text) {
        return UtilsGUI.createTextField(text, 0);
    }

    public static JTextField createTextField(String text, int cols) {
        JTextField b = new JTextField(text, cols);
        return b;
    }

    public static JButton createButton() {
        return UtilsGUI.createButton("");
    }

    public static JButton createButton(String text) {
        return UtilsGUI.createButton(text, false);
    }

    public static JButton createButton(String text, boolean bold) {
        JButton b = new JButton(text);
        if (bold) {
            b.setFont(b.getFont().deriveFont(1));
        }
        b.setOpaque(buttonOpaque);
        if (PlatformDefaults.getCurrentPlatform() == 1) {
            b.setContentAreaFilled(false);
        }
        return b;
    }

    public static JToggleButton createToggleButton(String text) {
        JToggleButton b = new JToggleButton(text);
        b.setOpaque(buttonOpaque);
        return b;
    }

    public static JCheckBox createCheck(String text) {
        JCheckBox b = new JCheckBox(text);
        b.setOpaque(buttonOpaque);
        return b;
    }

    public static JPanel createTabPanel(LayoutManager lm) {
        JPanel panel = new JPanel(lm);
        panel.setOpaque(buttonOpaque);
        return panel;
    }

    public static JComponent createPanel() {
        return UtilsGUI.createPanel("");
    }

    public static JComponent createPanel(String s) {
        JLabel panel = new JLabel(s, 0);
        panel.setBorder(new EtchedBorder());
        panel.setOpaque(true);
        return panel;
    }

    public static JTextArea createTextArea(String text, int rows, int cols) {
        JTextArea ta = new JTextArea(text, rows, cols);
        ta.setBorder(UIManager.getBorder("TextField.border"));
        ta.setFont(UIManager.getFont("TextField.font"));
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        return ta;
    }

    public static JScrollPane createTextAreaScroll(String text, int rows, int cols, boolean hasVerScroll) {
        JTextArea ta = new JTextArea(text, rows, cols);
        ta.setFont(UIManager.getFont("TextField.font"));
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(ta, hasVerScroll ? 20 : 21, 31);
        return scroll;
    }

    public static void addSeparator(JPanel panel, String text) {
        JLabel l = UtilsGUI.createLabel(text);
        l.setForeground(LABEL_COLOR);
        panel.add((Component)l, "gapbottom 1, span, split 2");
        panel.add((Component)new JSeparator(), "gapleft rel, growx");
    }

    public static class CheckBoxEditor
    extends DefaultCellEditor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final JCheckBox checkBox = new JCheckBox();

        public CheckBoxEditor() {
            super(checkBox);
            checkBox.setHorizontalAlignment(0);
        }
    }

    public class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer,
    Serializable {
        private static final long serialVersionUID = -8068756382226198363L;

        public CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    public class ComboBoxEditor
    extends DefaultCellEditor
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public ComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    public class ComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer,
    Serializable {
        private static final long serialVersionUID = 1L;

        public ComboBoxRenderer(String[] items) {
            super(items);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelectedItem(value);
            return this;
        }
    }

    public class EachRowEditor
    implements TableCellEditor,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected ArrayList<TableCellEditor> editors;
        protected TableCellEditor editor;
        protected TableCellEditor defaultEditor;
        JTable table;

        public EachRowEditor(JTable table) {
            this.table = table;
            this.editors = new ArrayList();
            this.defaultEditor = new DefaultCellEditor(new JTextField());
        }

        public void setEditorAt(int row, TableCellEditor editor) {
            this.editors.add(row, editor);
        }

        public void remove(int row) {
            this.editors.remove(row);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editor = this.editors.get(row);
            if (this.editor == null) {
                this.editor = this.defaultEditor;
            }
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public Object getCellEditorValue() {
            return this.editor.getCellEditorValue();
        }

        public boolean stopCellEditing() {
            return this.editor.stopCellEditing();
        }

        public void cancelCellEditing() {
            this.editor.cancelCellEditing();
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                this.selectEditor((MouseEvent)anEvent);
            }
            return this.editor.isCellEditable(anEvent);
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.editor.addCellEditorListener(l);
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.editor.removeCellEditorListener(l);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                this.selectEditor((MouseEvent)anEvent);
            }
            return this.editor.shouldSelectCell(anEvent);
        }

        protected void selectEditor(MouseEvent e) {
            int row = e == null ? this.table.getSelectionModel().getAnchorSelectionIndex() : this.table.rowAtPoint(e.getPoint());
            this.editor = this.editors.get(row);
            if (this.editor == null) {
                this.editor = this.defaultEditor;
            }
        }
    }

    public class EachRowRenderer
    implements TableCellRenderer,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected ArrayList<TableCellRenderer> renderers = new ArrayList();
        protected TableCellRenderer renderer;
        protected TableCellRenderer defaultRenderer = new DefaultTableCellRenderer();

        public void add(int row, TableCellRenderer renderer) {
            this.renderers.add(row, renderer);
        }

        public void remove(int row) {
            this.renderers.remove(row);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.renderer = this.renderers.get(row);
            if (this.renderer == null) {
                this.renderer = this.defaultRenderer;
            }
            return this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    public class JTableButtonEditor
    extends DefaultCellEditor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected JButton button;
        private String label;

        public JTableButtonEditor(JButton button) {
            super(new JCheckBox());
            this.button = button;
            button.setOpaque(true);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableButtonEditor.this.fireEditingStopped();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            if (value != null && value instanceof JButton) {
                this.label = ((JButton)value).getText();
                this.button.setText(this.label);
            }
            return this.button;
        }

        public Object getCellEditorValue() {
            return this.button;
        }

        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    public class JTableButtonMouseListener
    implements MouseListener,
    Serializable {
        private JTable table;

        public JTableButtonMouseListener(JTable table) {
            this.table = table;
        }

        private void forwardEventToButton(MouseEvent e) {
            TableColumnModel columnModel = this.table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row >= this.table.getRowCount() || row < 0 || column >= this.table.getColumnCount() || column < 0) {
                return;
            }
            Object value = this.table.getValueAt(row, column);
            if (!(value instanceof JButton)) {
                return;
            }
            JButton button = (JButton)value;
            MouseEvent buttonEvent = SwingUtilities.convertMouseEvent(this.table, e, button);
            button.dispatchEvent(buttonEvent);
            this.table.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        public void mouseExited(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        public void mousePressed(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.forwardEventToButton(e);
        }
    }

    public class JTableButtonRenderer
    extends JButton
    implements TableCellRenderer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private JButton button;
        private String label;

        public JTableButtonRenderer(JButton button) {
            this.button = button;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(UIManager.getColor("Button.background"));
            }
            if (value != null && value instanceof JButton) {
                this.label = ((JButton)value).getText();
                this.button.setText(this.label);
            }
            return this.button;
        }
    }

    public class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private JRadioButton button;

        public RadioButtonEditor() {
            super(new JCheckBox(""));
            this.button = new JRadioButton("");
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            this.button.setSelected((Boolean)value);
            this.button.addItemListener(this);
            this.button.setHorizontalAlignment(0);
            return this.button;
        }

        public Object getCellEditorValue() {
            return this.button;
        }

        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
        }
    }

    public class RadioButtonRenderer
    extends JCheckBox
    implements TableCellRenderer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private JRadioButton button;

        public RadioButtonRenderer() {
            super("");
            this.button = new JRadioButton();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            this.button.setSelected((Boolean)value);
            this.button.setHorizontalAlignment(0);
            return this.button;
        }
    }

    public class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer,
    Serializable {
        private static final long serialVersionUID = 1L;

        public RowHeaderRenderer(JTable table, boolean border) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

