/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.evaluation.batchEvaluation;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;
import unbbayes.datamining.preprocessor.imbalanceddataset.Baseline;
import unbbayes.datamining.preprocessor.imbalanceddataset.Batch;
import unbbayes.datamining.preprocessor.imbalanceddataset.Cclear;
import unbbayes.datamining.preprocessor.imbalanceddataset.ClusterBasedOversampling;
import unbbayes.datamining.preprocessor.imbalanceddataset.ClusterBasedSmote;
import unbbayes.datamining.preprocessor.imbalanceddataset.ClusterBasedUtils;
import unbbayes.datamining.preprocessor.imbalanceddataset.Original;
import unbbayes.datamining.preprocessor.imbalanceddataset.RandomOversampling;
import unbbayes.datamining.preprocessor.imbalanceddataset.Simplesampling;
import unbbayes.datamining.preprocessor.imbalanceddataset.Smote;

public class InitializePreprocessors {
    private int totalNumBatchIterations;
    private int numPreprocessors;
    private ArrayList<Integer> preprocessorOrder;
    private ArrayList<Batch> preprocessorList;
    private Original original;
    private Simplesampling simplesampling;
    private RandomOversampling oversampling;
    private Smote smote;
    private ClusterBasedOversampling cbo;
    private ClusterBasedSmote cbs;
    private Cclear cClear;
    private Baseline baseline;
    private ClusterBasedUtils clusterBasedUtils;
    private ArrayList<Integer> numBatchIterations;
    private int currentPreprocessorID = 0;
    private int currentBatchIterationID = -1;

    public InitializePreprocessors(InstanceSet instanceSet, PreprocessorParameters[] preprocessors) throws Exception {
        this.instantiate(instanceSet, preprocessors);
        this.computeNumBatchIterations();
    }

    public void instantiate(InstanceSet instanceSet, PreprocessorParameters[] preprocessors) throws Exception {
        this.numPreprocessors = preprocessors.length;
        this.numBatchIterations = new ArrayList(this.numPreprocessors);
        this.preprocessorList = new ArrayList(this.numPreprocessors);
        this.preprocessorOrder = new ArrayList();
        int i = 0;
        while (i < this.numPreprocessors) {
            int preprocessorID = preprocessors[i].getPreprocessorID();
            this.preprocessorOrder.add(preprocessorID);
            this.instantiateAux(instanceSet, preprocessors[i]);
            ++i;
        }
    }

    private void instantiateAux(InstanceSet instanceSet, PreprocessorParameters parameters) throws Exception {
        this.clusterBasedUtils = new ClusterBasedUtils(instanceSet);
        int preprocessorID = parameters.getPreprocessorID();
        switch (preprocessorID) {
            case 0: {
                this.original = new Original(instanceSet, parameters);
                this.numBatchIterations.add(this.original.getNumBatchIterations());
                this.preprocessorList.add(this.original);
                break;
            }
            case 1: {
                this.oversampling = new RandomOversampling(instanceSet, parameters);
                this.numBatchIterations.add(this.oversampling.getNumBatchIterations());
                this.preprocessorList.add(this.oversampling);
                break;
            }
            case 2: {
                this.simplesampling = new Simplesampling(instanceSet, parameters);
                this.numBatchIterations.add(this.simplesampling.getNumBatchIterations());
                this.preprocessorList.add(this.simplesampling);
                break;
            }
            case 3: {
                this.smote = new Smote(instanceSet, parameters);
                this.numBatchIterations.add(this.smote.getNumBatchIterations());
                this.preprocessorList.add(this.smote);
                break;
            }
            case 4: {
                this.cbo = new ClusterBasedOversampling(this.clusterBasedUtils, instanceSet, parameters);
                this.numBatchIterations.add(this.cbo.getNumBatchIterations());
                this.preprocessorList.add(this.cbo);
                break;
            }
            case 5: {
                this.cbs = new ClusterBasedSmote(this.clusterBasedUtils, instanceSet, parameters);
                this.numBatchIterations.add(this.cbs.getNumBatchIterations());
                this.preprocessorList.add(this.cbs);
                break;
            }
            case 6: {
                this.cClear = new Cclear(this.clusterBasedUtils, instanceSet, parameters);
                this.numBatchIterations.add(this.cClear.getNumBatchIterations());
                this.preprocessorList.add(this.cClear);
                break;
            }
            case 7: {
                this.baseline = new Baseline(instanceSet, parameters);
                this.numBatchIterations.add(this.baseline.getNumBatchIterations());
                this.preprocessorList.add(this.baseline);
            }
        }
    }

    private void computeNumBatchIterations() {
        this.totalNumBatchIterations = 0;
        int i = 0;
        while (i < this.numBatchIterations.size()) {
            this.totalNumBatchIterations += this.numBatchIterations.get(i).intValue();
            ++i;
        }
    }

    public int[] getNextBatchID() throws Exception {
        ++this.currentBatchIterationID;
        int maxBatchIterations = this.numBatchIterations.get(this.currentPreprocessorID);
        if (this.currentBatchIterationID >= maxBatchIterations) {
            this.currentBatchIterationID = 0;
        }
        int[] batchID = new int[]{++this.currentPreprocessorID, this.currentBatchIterationID};
        return batchID;
    }

    public void applyPreprocessor(InstanceSet instanceSet, int[] batchID) throws Exception {
        if (batchID == null) {
            batchID = this.getNextBatchID();
        }
        this.currentPreprocessorID = batchID[0];
        this.currentBatchIterationID = batchID[1];
        if (this.currentBatchIterationID == 0) {
            System.out.print(new SimpleDateFormat("HH:mm:ss").format(new Date()));
            System.out.println(": preprocessorID: " + this.currentPreprocessorID);
        }
        Batch preprocessor = this.preprocessorList.get(this.currentPreprocessorID);
        preprocessor.getNextBatchIteration(instanceSet);
    }

    public String getPreprocessorName() {
        return this.getPreprocessorName(this.currentPreprocessorID);
    }

    public String getPreprocessorName(int preprocessorID) {
        Batch currentPreprocessor = this.preprocessorList.get(preprocessorID);
        return currentPreprocessor.getPreprocessorName();
    }

    public String getPreprocessorParameters() {
        Batch currentPreprocessor = this.preprocessorList.get(this.currentPreprocessorID);
        return currentPreprocessor.parametersToString(this.currentBatchIterationID);
    }

    public int getTotalNumBatchIterations() {
        return this.totalNumBatchIterations;
    }

    public int getNumPreprocessors() {
        return this.preprocessorOrder.size();
    }

    public int[] getCurrentBatchID() {
        int[] preprocessorID = new int[]{this.currentPreprocessorID, this.currentBatchIterationID};
        return preprocessorID;
    }

    public int getPreprocessorID() {
        return this.currentPreprocessorID;
    }
}

