/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.distance;

import unbbayes.datamining.datamanipulation.AttributeStats;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Stats;
import unbbayes.datamining.datamanipulation.Utils;
import unbbayes.datamining.distance.Distance;

public class HVDM
extends Distance {
    private int numAttributes;
    private int numInstances;
    private int numClasses;
    private double[] attNorm;
    private float[][][] distribution;
    private AttributeStats[] attributeStats;
    private byte[] attributeType;
    private float[] attRangeValue;
    private float[] attHalfRangeValue;
    public int classIndex;
    public int counterIndex;
    private byte optionDistanceFunction;
    private byte HAMMING = 0;
    private byte HVDM = 1;

    public HVDM(InstanceSet instanceSet, int normFactor) throws Exception {
        this.numAttributes = instanceSet.numAttributes();
        this.numInstances = instanceSet.numInstances();
        this.classIndex = instanceSet.classIndex;
        this.numClasses = 0;
        if (this.classIndex != -1) {
            this.numClasses = instanceSet.numClasses();
        }
        this.attributeType = instanceSet.attributeType;
        this.attributeStats = instanceSet.getAttributeStats();
        this.counterIndex = instanceSet.counterIndex;
        this.attNorm = new double[this.numInstances];
        this.attRangeValue = new float[this.numInstances];
        this.attHalfRangeValue = new float[this.numInstances];
        int att = 0;
        while (att < this.numAttributes) {
            if (att != this.classIndex) {
                Stats stats;
                if (this.attributeType[att] == 0) {
                    stats = this.attributeStats[att].getNumericStats();
                    this.attNorm[att] = stats.getStdDev() * (double)normFactor;
                } else if (instanceSet.attributeType[att] == 2) {
                    stats = this.attributeStats[att].getNumericStats();
                    this.attNorm[att] = stats.getStdDev() * (double)normFactor;
                    this.attRangeValue[att] = stats.getMax() - stats.getMin() + 1.0f;
                    this.attHalfRangeValue[att] = this.attRangeValue[att] / 2.0f;
                } else {
                    byte cfr_ignored_0 = instanceSet.attributeType[att];
                }
            }
            ++att;
        }
        if (instanceSet.numNominalAttributes > 1 || instanceSet.numNominalAttributes == 1 && instanceSet.classIsNominal()) {
            this.distribution = Utils.computeNominalDistributions(instanceSet);
        }
    }

    public void setOptionDistanceFunction(byte optionDistanceFunction) {
        this.optionDistanceFunction = optionDistanceFunction;
    }

    public float distanceValue(float[] vector1, float[] vector2) {
        int attIndex = 0;
        double distance = 0.0;
        int att = 0;
        while (att < this.numAttributes) {
            double attDif = 0.0;
            if (att != this.classIndex) {
                if (vector1[att] == vector2[att]) {
                    if (this.attributeType[att] == 1) {
                        ++attIndex;
                    }
                } else {
                    if (this.attributeType[att] == 1) {
                        attDif = this.distanceNominal(vector1, vector2, att, attIndex);
                        ++attIndex;
                    } else if (this.attributeType[att] == 0) {
                        attDif = vector1[att] - vector2[att];
                        attDif /= this.attNorm[att];
                    } else if (this.attributeType[att] == 2) {
                        attDif = Math.abs(vector1[att] - vector2[att]);
                        if (attDif > (double)this.attHalfRangeValue[att]) {
                            attDif = (double)this.attRangeValue[att] - attDif;
                        }
                        attDif /= this.attNorm[att];
                    }
                    distance += attDif * attDif;
                }
            }
            ++att;
        }
        distance = Math.sqrt(distance);
        return (float)distance;
    }

    private double distanceNominal(float[] vector1, float[] vector2, int att, int attIndex) {
        double attDif = 0.0;
        if (this.optionDistanceFunction == this.HVDM) {
            AttributeStats attStats = this.attributeStats[att];
            int k = 0;
            while (k < this.numClasses) {
                int index = (int)vector1[att];
                float aux1 = this.distribution[k][attIndex][index];
                aux1 /= attStats.nominalCountsWeighted[index];
                index = (int)vector2[att];
                float aux2 = this.distribution[k][attIndex][index];
                attDif += (double)((aux1 - (aux2 /= attStats.nominalCountsWeighted[index])) * (aux1 - aux2));
                ++k;
            }
        } else if (this.optionDistanceFunction == this.HAMMING && vector1[att] != vector2[att]) {
            attDif = 1.0;
        }
        return attDif;
    }
}

