/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.distance;

import unbbayes.datamining.datamanipulation.AttributeStats;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Stats;
import unbbayes.datamining.datamanipulation.Utils;
import unbbayes.datamining.distance.Distance;

public class Euclidean
extends Distance {
    private InstanceSet instanceSet;
    private int numAttributes;
    private int numNumericAttributes;
    private double[] attNorm;
    private double[] minValue;
    private double[] maxValue;
    private boolean normalize;

    public Euclidean(InstanceSet instanceSet, int normFactor, boolean normalize) {
        this.instanceSet = instanceSet;
        this.normalize = normalize;
        this.numAttributes = instanceSet.numAttributes;
        this.numNumericAttributes = instanceSet.numNumericAttributes;
        AttributeStats[] attributeStats = instanceSet.getAttributeStats();
        this.minValue = new double[this.numNumericAttributes];
        this.maxValue = new double[this.numNumericAttributes];
        this.attNorm = new double[instanceSet.numNumericAttributes];
        int attIndex = 0;
        int att = 0;
        while (att < this.numAttributes) {
            if (att != instanceSet.classIndex && instanceSet.attributeType[att] == 0) {
                Stats stats = attributeStats[att].getNumericStats();
                this.attNorm[attIndex] = stats.getStdDev() * (double)normFactor;
                if (this.attNorm[attIndex] == 0.0) {
                    this.attNorm[attIndex] = Double.MAX_VALUE;
                }
                this.minValue[attIndex] = stats.getMin();
                this.maxValue[attIndex] = stats.getMax();
                ++attIndex;
            }
            ++att;
        }
    }

    public float distanceValue(float[] vector1, float[] vector2) {
        double result = 0.0;
        if (this.normalize) {
            int att = 0;
            while (att < this.numNumericAttributes) {
                double dist = this.norm(vector1[att], att) - this.norm(vector2[att], att);
                result += dist * dist;
                ++att;
            }
            return (float)result;
        }
        int att = 0;
        while (att < this.numNumericAttributes) {
            double dist = (double)(vector1[att] - vector2[att]) / this.attNorm[att];
            result += dist * dist;
            ++att;
        }
        return (float)Math.sqrt(result);
    }

    private double norm(double x, int i) {
        if (Double.isNaN(this.minValue[i]) || Utils.eq(this.maxValue[i], this.minValue[i])) {
            return 0.0;
        }
        return (x - this.minValue[i]) / (this.maxValue[i] - this.minValue[i]);
    }
}

