/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.discretize;

import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.discretize.IDiscretization;

public class EntropyDiscretization
implements IDiscretization {
    private int numThresholds;
    private InstanceSet inst;

    public EntropyDiscretization(InstanceSet inst) {
        this.inst = new InstanceSet(inst);
    }

    public void discretizeAttribute(Attribute att) {
        this.discretizeAttribute(att, 10);
    }

    public void discretizeAttribute(Attribute att, int numThresholds) {
        if (!att.isNumeric()) {
            throw new IllegalArgumentException("Attribute not numeric");
        }
        int numInstances = this.inst.numInstances();
        if (numInstances == 0) {
            return;
        }
        if (numThresholds < 1) {
            numThresholds = 1;
        }
    }

    public void autoDiscretize() {
        this.autoDiscretize(10);
    }

    public void autoDiscretize(int numThresholds) {
        int numAttributes = this.inst.numAttributes();
        int i = 0;
        while (i < numAttributes) {
            Attribute att = this.inst.getAttribute(i);
            if (att.isNumeric()) {
                this.discretizeAttribute(att, numThresholds);
            }
            ++i;
        }
    }

    public InstanceSet getInstances() {
        return this.inst;
    }

    private void insertionSortInc(float[] a, byte[] b) {
        int j = 1;
        while (j < a.length) {
            float key = a[j];
            byte temp = b[j];
            int i = j - 1;
            while (i > -1 && a[i] > key) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
                --i;
            }
            a[i + 1] = key;
            b[i + 1] = temp;
            ++j;
        }
    }
}

