/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.io.Serializable;
import java.util.ArrayList;

public class NumericData
implements Serializable {
    private int index;
    private ArrayList<Double> cuts;
    private ArrayList<Double> gains;
    private ArrayList<float[]> instancesAbove;
    private ArrayList<float[]> instancesBelow;
    private float[] missingValuesDistribution;

    public NumericData(int index, float[] missingValuesDistribution) {
        this.index = index;
        this.missingValuesDistribution = missingValuesDistribution;
        this.cuts = new ArrayList();
        this.gains = new ArrayList();
        this.instancesAbove = new ArrayList();
        this.instancesBelow = new ArrayList();
    }

    public void addData(double cut, double gain, float[] instancesBelow, float[] instancesAbove) {
        this.cuts.add(new Double(cut));
        this.gains.add(new Double(gain));
        this.instancesBelow.add(instancesBelow);
        this.instancesAbove.add(instancesAbove);
    }

    public int getNumberOfCuts() {
        return this.cuts.size();
    }

    public int getIndex() {
        return this.index;
    }

    public float[] getMissingValuesDistribution() {
        return this.missingValuesDistribution;
    }

    public double getCut(int index) {
        if (index > this.getNumberOfCuts()) {
            return Double.MIN_VALUE;
        }
        return this.cuts.get(index);
    }

    public double getGain(int index) {
        if (index + 1 > this.getNumberOfCuts()) {
            return Double.MIN_VALUE;
        }
        return this.gains.get(index);
    }

    public float[] getInstancesBelow(int index) {
        if (index > this.getNumberOfCuts()) {
            return null;
        }
        return this.instancesBelow.get(index);
    }

    public float[] getInstancesAbove(int index) {
        if (index > this.getNumberOfCuts()) {
            return null;
        }
        return this.instancesAbove.get(index);
    }
}

