/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.distance.HVDM;
import unbbayes.datamining.evaluation.batchEvaluation.GlobalBatchParameters;

public class NearestNeighbors {
    private InstanceSet instanceSet;
    private Instance[] instances;
    private int classIndex;
    private int numInstances;
    private int[][] nearestNeighborsIDs;
    private byte optionDistanceFunction;
    private int numNN = 5;

    public NearestNeighbors(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
        this.numInstances = instanceSet.numInstances();
        this.instances = instanceSet.instances;
        this.classIndex = instanceSet.classIndex;
        this.initialize();
    }

    public NearestNeighbors(InstanceSet instanceSet, byte optionDistanceFunction) {
        this(instanceSet);
        this.optionDistanceFunction = optionDistanceFunction;
    }

    public int[][] build(int interestingClass) throws Exception {
        int numInstances = this.instanceSet.numInstances();
        int counter = 0;
        int[] instancesIDsTmp = new int[numInstances];
        int inst = 0;
        while (inst < numInstances) {
            if (this.instances[inst].data[this.classIndex] == (float)interestingClass) {
                instancesIDsTmp[counter] = inst;
                ++counter;
            }
            ++inst;
        }
        int[] instancesIDs = new int[counter];
        int i = 0;
        while (i < counter) {
            instancesIDs[i] = instancesIDsTmp[i];
            ++i;
        }
        return this.build(instancesIDs);
    }

    public int[][] buildNNAll() throws Exception {
        int[] instancesIDs = new int[this.numInstances];
        int inst = 0;
        while (inst < this.numInstances) {
            instancesIDs[inst] = inst;
            ++inst;
        }
        return this.build(instancesIDs);
    }

    public int[][] build(int[] instancesIDs) throws Exception {
        int numInstancesIDs = instancesIDs.length;
        this.nearestNeighborsIDs = new int[numInstancesIDs][this.numNN];
        float[][] nearestNeighborsDistance = new float[numInstancesIDs][this.numNN];
        int i = 0;
        while (i < numInstancesIDs) {
            int j = 0;
            while (j < this.numNN) {
                this.nearestNeighborsIDs[i][j] = -1;
                nearestNeighborsDistance[i][j] = Float.POSITIVE_INFINITY;
                ++j;
            }
            ++i;
        }
        int normFactor = 4;
        HVDM distance = new HVDM(this.instanceSet, normFactor);
        distance.setOptionDistanceFunction(this.optionDistanceFunction);
        this.instances = this.instanceSet.instances;
        float dist = 0.0f;
        int distGreaterID = 0;
        int i2 = 0;
        while (i2 < numInstancesIDs) {
            int instI = instancesIDs[i2];
            float distGreater = Float.POSITIVE_INFINITY;
            int j = 0;
            while (j < numInstancesIDs) {
                int instJ = instancesIDs[j];
                dist = distance.distanceValue(this.instances[instI].data, this.instances[instJ].data);
                if (dist < distGreater) {
                    this.nearestNeighborsIDs[i2][distGreaterID] = instJ;
                    nearestNeighborsDistance[i2][distGreaterID] = dist;
                    distGreater = 0.0f;
                    int d = 0;
                    while (d < this.numNN) {
                        if (distGreater < nearestNeighborsDistance[i2][d]) {
                            distGreater = nearestNeighborsDistance[i2][d];
                            this.nearestNeighborsIDs[i2][distGreaterID] = instJ;
                            distGreaterID = d;
                        }
                        ++d;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return this.nearestNeighborsIDs;
    }

    private void initialize() {
        this.optionDistanceFunction = GlobalBatchParameters.getInstance().getOptionDistanceFunction();
    }
}

