/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import unbbayes.controller.IProgress;
import unbbayes.datamining.datamanipulation.InstanceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Loader
implements IProgress {
    protected InstanceSet instanceSet;
    protected String counterAttributeName = "Total";
    protected int counterIndex = -1;
    protected int initialInstances = 0;
    protected StreamTokenizer tokenizer;
    protected boolean compacted;
    protected boolean checkedCompacted = false;
    protected byte[] attributeType;
    protected static final byte NUMERIC = 0;
    protected static final byte NOMINAL = 1;
    protected static final byte CYCLIC = 2;
    protected int numAttributes;
    public File file;
    protected boolean[] attributeIsString;
    protected String[] attributeName;
    protected int likelyCounterIndex = -1;
    private int classIndex;

    public void setAttributeType(byte[] attributeType) {
        this.attributeType = attributeType;
    }

    public void setAttributeIsString(boolean[] attributeIsString) {
        this.attributeIsString = attributeIsString;
    }

    public void setNumAttributes(int numAttributes) {
        this.numAttributes = numAttributes;
    }

    public void setCounterAttribute(int counterIndex) {
        this.counterIndex = counterIndex;
    }

    public InstanceSet getInstanceSet() {
        this.instanceSet.setFinal();
        if (!this.checkedCompacted) {
            this.instanceSet.setCompacted(false);
            int inst = 0;
            while (inst < this.instanceSet.numInstances) {
                float weight = this.instanceSet.instances[inst].data[this.instanceSet.counterIndex];
                if (weight > 1.0f) {
                    this.instanceSet.setCompacted(true);
                    break;
                }
                ++inst;
            }
            this.checkedCompacted = true;
        }
        return this.instanceSet;
    }

    protected abstract void initTokenizer();

    public abstract void buildHeader() throws IOException;

    public abstract void readHeader() throws IOException;

    public abstract ArrayList<Object> getHeaderInfo() throws IOException;

    public abstract boolean getInstance() throws IOException;

    protected abstract void getFirstToken() throws IOException;

    protected abstract void getNextToken() throws IOException;

    protected void errms(String theMsg) throws IOException {
        throw new IOException(String.valueOf(theMsg) + ", read " + this.tokenizer.toString());
    }

    public int getInitialInstancesCount() {
        return this.initialInstances;
    }

    @Override
    public boolean next() {
        boolean result = false;
        try {
            result = this.getInstance();
        }
        catch (IOException ioe) {
            result = false;
        }
        return result;
    }

    @Override
    public void cancel() {
        this.instanceSet = null;
    }

    @Override
    public int maxCount() {
        return this.initialInstances;
    }

    protected void countInstancesFromFile(File file, int num, boolean txt) throws IOException {
        String line;
        FileInputStream fileIn = new FileInputStream(file);
        InputStreamReader inReader = new InputStreamReader(fileIn);
        BufferedReader in = new BufferedReader(inReader);
        int count = 0;
        boolean startCount = false;
        if (txt) {
            startCount = true;
        }
        while ((line = in.readLine()) != null) {
            if (startCount && !line.startsWith("%")) {
                ++count;
            }
            if (line.toLowerCase().equals("@data")) {
                startCount = true;
            }
            if (num != -1 && count >= num) break;
        }
        this.initialInstances = count;
        fileIn.close();
    }

    protected abstract boolean getInstanceAux() throws IOException;

    public int getNumAttributes() {
        return this.numAttributes;
    }

    public int getLikelyCounterIndex() {
        return this.likelyCounterIndex;
    }

    public void setAttributeName(String[] attributeName) {
        this.attributeName = attributeName;
    }

    public void setCounterAttributeName(String counterAttributeName) {
        this.counterAttributeName = counterAttributeName;
    }

    public void setCompacted(boolean compacted) {
        this.compacted = compacted;
    }

    public int getnumInitialInstances() {
        return this.initialInstances;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }
}

