/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import unbbayes.controller.FileController;
import unbbayes.datamining.datamanipulation.ArffLoader;
import unbbayes.datamining.datamanipulation.Loader;
import unbbayes.datamining.datamanipulation.TxtLoader;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.datamanipulation.resources.DataManipulationResource");
    public static final byte OPEN_FILE_DIALOG = 0;
    public static final byte SAVE_FILE_DIALOG = 1;

    private static SimpleFileFilter bevFileFilter() {
        String[] filter = new String[]{"BEV"};
        String filterText = resource.getString("besFilterText");
        return new SimpleFileFilter(filter, filterText);
    }

    private static SimpleFileFilter getArffFileFilter() {
        String[] filter = new String[]{"ARFF"};
        String filterText = resource.getString("arffFilterText");
        return new SimpleFileFilter(filter, filterText);
    }

    public static File openBevFile(JInternalFrame window, String[] returnStatus) {
        String dialogTitle = resource.getString("openBevDialog");
        String successText = resource.getString("openBevSuccess");
        SimpleFileFilter fileFilter = FileUtils.bevFileFilter();
        File file = null;
        file = FileUtils.openFile(dialogTitle, successText, fileFilter, (byte)1, window, returnStatus);
        return file;
    }

    public static File saveBevFile(JInternalFrame window, String[] returnStatus) {
        String dialogTitle = resource.getString("saveBevDialog");
        String successText = resource.getString("saveBevSuccess");
        SimpleFileFilter fileFilter = FileUtils.bevFileFilter();
        File file = null;
        file = FileUtils.openFile(dialogTitle, successText, fileFilter, (byte)1, window, returnStatus);
        return file;
    }

    public static File openArffFile(JInternalFrame window, String[] returnStatus) {
        String dialogTitle = resource.getString("openArffDialog");
        String successText = resource.getString("openArffSuccess");
        SimpleFileFilter fileFilter = FileUtils.getArffFileFilter();
        File file = FileUtils.openFile(dialogTitle, successText, fileFilter, (byte)0, window, returnStatus);
        return file;
    }

    public File saveArffFile(JInternalFrame window, String[] returnStatus) {
        String dialogTitle = resource.getString("saveArffDialog");
        String successText = resource.getString("saveArffSuccess");
        SimpleFileFilter fileFilter = FileUtils.getArffFileFilter();
        File file = FileUtils.openFile(dialogTitle, successText, fileFilter, (byte)1, window, returnStatus);
        return file;
    }

    public static File openFile(String dialogTitle, String successText, SimpleFileFilter fileFilter, byte type, JInternalFrame window, String[] returnStatus) {
        File selectedFile = null;
        File currentPath = FileController.getInstance().getCurrentDirectory();
        JFileChooser fileChooser = new JFileChooser(currentPath);
        fileChooser.setDialogTitle(dialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter(fileFilter);
        fileChooser.setFileView(new FileIcon(window));
        window.setCursor(new Cursor(3));
        int returnVal = -1;
        switch (type) {
            case 0: {
                returnVal = fileChooser.showOpenDialog(window);
                break;
            }
            case 1: {
                returnVal = fileChooser.showSaveDialog(window);
            }
        }
        if (returnVal == 0) {
            selectedFile = fileChooser.getSelectedFile();
            currentPath = fileChooser.getCurrentDirectory();
            FileController.getInstance().setCurrentDirectory(currentPath);
            returnStatus[0] = new String(successText);
        } else {
            String cancelText = resource.getString("canceledDialog");
            returnStatus[0] = new String(cancelText);
        }
        window.setCursor(new Cursor(0));
        return selectedFile;
    }

    public static ArrayList<Object> getFileHeaderInfo(File file) throws IOException {
        Loader loader;
        String fileName = file.getName();
        if (fileName.regionMatches(true, fileName.length() - 5, ".arff", 0, 5)) {
            loader = new ArffLoader(file, 0);
        } else if (fileName.regionMatches(true, fileName.length() - 4, ".txt", 0, 4)) {
            loader = new TxtLoader(file, 1);
        } else {
            throw new IOException(resource.getString("fileExtensionException"));
        }
        return ((Loader)loader).getHeaderInfo();
    }
}

