/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import unbbayes.datamining.classifiers.decisiontree.SplitObject;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.NumericData;
import unbbayes.datamining.datamanipulation.Utils;

public class ClassifierUtils {
    private HashMap<Double, Double> logmap;
    private static final double LN2 = Math.log(2.0);
    private InstanceSet instances;

    public ClassifierUtils(InstanceSet inst) {
        this.instances = inst;
        this.logmap = new HashMap();
        Double zeroDouble = new Double(0.0);
        if (this.logmap.containsKey(zeroDouble)) {
            this.logmap.put(zeroDouble, zeroDouble);
        }
        if (this.logmap.containsKey(zeroDouble)) {
            this.logmap.put(new Double(0.0), zeroDouble);
        }
    }

    public double xlog2(double a) {
        Double aDouble = new Double(a);
        if (a == 0.0) {
            return 0.0;
        }
        if (this.logmap.containsKey(aDouble)) {
            return this.logmap.get(aDouble);
        }
        double newLog = a * Math.log(a) / LN2;
        this.logmap.put(aDouble, new Double(newLog));
        return newLog;
    }

    public SplitObject[] splitData(SplitObject split, int attIndex) {
        Integer[] att = split.getAttributes();
        int attribute = att[attIndex];
        int numAtt = att.length;
        Integer[] newAttributes = new Integer[numAtt - 1];
        ArrayList inst = split.getInstances();
        int numValues = this.instances.getAttribute(attribute).numValues();
        int i = 0;
        int j = 0;
        while (i < numAtt) {
            if (attIndex != i) {
                newAttributes[j] = att[i];
                ++j;
            }
            ++i;
        }
        ArrayList[] data = new ArrayList[numValues];
        int i2 = 0;
        while (i2 < numValues) {
            data[i2] = new ArrayList();
            ++i2;
        }
        int numInst = inst.size();
        float[] numInstancesPerValue = new float[numValues];
        ArrayList<Instance> missingValueInstances = new ArrayList<Instance>();
        int i3 = 0;
        while (i3 < numInst) {
            Instance instance = this.getInstance(inst, i3);
            if (!instance.isMissing(attribute)) {
                int numDataset = (int)instance.getValue(attribute);
                data[numDataset].add(inst.get(i3));
                int n = numDataset;
                numInstancesPerValue[n] = numInstancesPerValue[n] + instance.getWeight();
            } else {
                missingValueInstances.add(instance);
            }
            ++i3;
        }
        float completeInstancesSum = Utils.sum(numInstancesPerValue);
        int i4 = 0;
        while (i4 < numValues) {
            int j2 = 0;
            while (j2 < missingValueInstances.size()) {
                if (numInstancesPerValue[i4] != 0.0f) {
                    Instance instance = (Instance)missingValueInstances.get(j2);
                    Instance newInstance = new Instance(instance);
                    newInstance.setInstanceSet(instance.getInstanceSet());
                    float newWeight = instance.getWeight() * numInstancesPerValue[i4];
                    newInstance.setWeight(newWeight /= completeInstancesSum);
                    data[i4].add(newInstance);
                }
                ++j2;
            }
            ++i4;
        }
        SplitObject[] splitObject = new SplitObject[numValues];
        int i5 = 0;
        while (i5 < numValues) {
            splitObject[i5] = new SplitObject(data[i5], newAttributes);
            ++i5;
        }
        return splitObject;
    }

    public SplitObject[] splitNumericData(SplitObject split, int attIndex, double splitValue) {
        Instance instance;
        Integer[] actualAtt = split.getAttributes();
        ArrayList actualInst = split.getInstances();
        SplitObject[] splitData = new SplitObject[2];
        int attribute = actualAtt[attIndex];
        Integer[] newAttributes = new Integer[actualAtt.length - 1];
        int i = 0;
        int j = 0;
        while (i < actualAtt.length) {
            if (attIndex != i) {
                newAttributes[j] = actualAtt[i];
                ++j;
            }
            ++i;
        }
        ArrayList instancesMoreThan = new ArrayList();
        ArrayList instancesLessThan = new ArrayList();
        ArrayList<Instance> missingValueInstances = new ArrayList<Instance>();
        float[] numInstancesPerValue = new float[2];
        int i2 = 0;
        while (i2 < actualInst.size()) {
            instance = this.getInstance(actualInst, i2);
            if (!instance.isMissing(attribute)) {
                if ((double)instance.getValue(attribute) >= splitValue) {
                    instancesMoreThan.add(actualInst.get(i2));
                    numInstancesPerValue[0] = numInstancesPerValue[0] + instance.getWeight();
                } else {
                    instancesLessThan.add(actualInst.get(i2));
                    numInstancesPerValue[1] = numInstancesPerValue[1] + instance.getWeight();
                }
            } else {
                missingValueInstances.add(instance);
            }
            ++i2;
        }
        float completeInstancesSum = Utils.sum(numInstancesPerValue);
        int i3 = 0;
        while (i3 < missingValueInstances.size()) {
            float newWeight;
            instance = (Instance)missingValueInstances.get(i3);
            Instance newInstance = new Instance(instance);
            newInstance.setInstanceSet(instance.getInstanceSet());
            if (numInstancesPerValue[0] != 0.0f) {
                newWeight = instance.getWeight() * numInstancesPerValue[0];
                newInstance.setWeight(newWeight /= completeInstancesSum);
                instancesMoreThan.add(newInstance);
            }
            if (numInstancesPerValue[1] != 0.0f) {
                newWeight = instance.getWeight() * numInstancesPerValue[1];
                newInstance.setWeight(newWeight /= completeInstancesSum);
                instancesLessThan.add(newInstance);
            }
            ++i3;
        }
        splitData[0] = new SplitObject(instancesMoreThan, newAttributes);
        splitData[1] = new SplitObject(instancesLessThan, newAttributes);
        return splitData;
    }

    public double[] computeInfoGain(SplitObject split) {
        double[] splitValues = new double[split.getAttributes().length];
        return this.computeInfoGain(split, splitValues, new ArrayList());
    }

    public double[] computeInfoGain(SplitObject split, double[] splitValues, ArrayList numericDataList) {
        Integer[] att = split.getAttributes();
        ArrayList inst = split.getInstances();
        int numClassValues = this.instances.numClasses();
        int numInst = inst.size();
        int classIndex = this.instances.getClassIndex();
        float[][][] counts = new float[att.length - 1][][];
        float[] totalSums = new float[att.length - 1];
        float[] totalCounts = new float[numClassValues];
        double[] resultGain = new double[att.length - 1];
        boolean[] hasMissingValues = new boolean[att.length - 1];
        int i = 0;
        while (i < att.length) {
            int attAux = att[i];
            if (this.instances.getAttribute(attAux).isNominal() && attAux != classIndex) {
                int numValues = this.instances.getAttribute(attAux).numValues();
                counts[i] = new float[numValues][numClassValues];
            }
            ++i;
        }
        Arrays.fill(hasMissingValues, false);
        int i2 = 0;
        while (i2 < numInst) {
            Instance instance = this.getInstance(inst, i2);
            if (!instance.classIsMissing()) {
                float weight = instance.getWeight();
                int j = 0;
                while (j < att.length) {
                    int attributeIndex = att[j];
                    if (this.instances.getAttribute(attributeIndex).isNominal() && attributeIndex != classIndex) {
                        if (!instance.isMissing(attributeIndex)) {
                            int value = (int)instance.getValue(attributeIndex);
                            int classValue = instance.getClassValue();
                            float[] fArray = counts[j][value];
                            int n = classValue;
                            fArray[n] = fArray[n] + weight;
                        } else {
                            hasMissingValues[j] = true;
                        }
                    }
                    ++j;
                }
                int n = instance.getClassValue();
                totalCounts[n] = totalCounts[n] + weight;
            }
            ++i2;
        }
        float totalSum = Utils.sum(totalCounts);
        double totalInfoGain = this.computeEntropy(totalCounts, totalSum);
        float[] attributeCounts = new float[numClassValues];
        int i3 = 0;
        while (i3 < counts.length) {
            double infoGain;
            if (hasMissingValues[i3]) {
                Arrays.fill(attributeCounts, 0.0f);
                int j = 0;
                while (j < counts[i3].length) {
                    int k = 0;
                    while (k < counts[i3][j].length) {
                        int n = k;
                        attributeCounts[n] = attributeCounts[n] + counts[i3][j][k];
                        ++k;
                    }
                    ++j;
                }
                totalSums[i3] = Utils.sum(attributeCounts);
                infoGain = this.computeEntropy(attributeCounts, totalSums[i3]);
            } else {
                totalSums[i3] = totalSum;
                infoGain = totalInfoGain;
            }
            resultGain[i3] = infoGain;
            ++i3;
        }
        if (counts.length == 0) {
            resultGain = new double[1];
            return resultGain;
        }
        int i4 = 0;
        while (i4 < counts.length) {
            int attIndex = att[i4];
            if (attIndex != classIndex) {
                if (this.instances.getAttribute(attIndex).isNominal()) {
                    int j = 0;
                    while (j < counts[i4].length) {
                        int n = i4;
                        resultGain[n] = resultGain[n] - this.computeEntropy(counts[i4][j], totalSums[i4]);
                        ++j;
                    }
                } else {
                    this.computeNumericAttEntropy(splitValues, numericDataList, resultGain, i4, inst, attIndex, numClassValues, totalSums);
                }
            }
            ++i4;
        }
        return resultGain;
    }

    private void computeNumericAttEntropy(double[] splitValues, ArrayList numericDataList, double[] resultGain, int i, ArrayList inst, int attIndex, int numClassValues, float[] totalSums) {
        float[] values = this.getDistinctSortedValues(inst, attIndex);
        int numDistinctValues = values.length;
        float[][] classDistribution = new float[numDistinctValues][numClassValues];
        float[] missingValuesDistribution = new float[numClassValues];
        Hashtable<Float, Integer> distinctValueHash = new Hashtable<Float, Integer>();
        int pos = 0;
        while (pos < numDistinctValues) {
            distinctValueHash.put(Float.valueOf(values[pos]), pos);
            ++pos;
        }
        int numInst = inst.size();
        int x = 0;
        while (x < numInst) {
            Instance instance = this.getInstance(inst, x);
            int classValue = instance.getClassValue();
            float weight = instance.getWeight();
            if (weight > 1.0f) {
                boolean bl = true;
            }
            if (!instance.isMissing(attIndex)) {
                float valueAux = instance.getValue(attIndex);
                int pos2 = (Integer)distinctValueHash.get(Float.valueOf(valueAux));
                float[] fArray = classDistribution[pos2];
                int n = classValue;
                fArray[n] = fArray[n] + weight;
            } else {
                int n = classValue;
                missingValuesDistribution[n] = missingValuesDistribution[n] + weight;
            }
            ++x;
        }
        float[] sumPart1 = new float[numClassValues];
        float[] sumPart2 = new float[numClassValues];
        int x2 = 0;
        while (x2 < numDistinctValues) {
            int y = 0;
            while (y < numClassValues) {
                int n = y;
                sumPart2[n] = sumPart2[n] + classDistribution[x2][y];
                ++y;
            }
            ++x2;
        }
        double minimumEntropy = 2.147483647E9;
        double minimumValue = 2.147483647E9;
        NumericData numericData = new NumericData(i, missingValuesDistribution);
        int x3 = 1;
        while (x3 < numDistinctValues) {
            float[] distribution1 = classDistribution[x3 - 1];
            float[] distribution2 = classDistribution[x3];
            double entropy = 0.0;
            int y = 0;
            while (y < numClassValues) {
                int n = y;
                sumPart1[n] = sumPart1[n] + classDistribution[x3 - 1][y];
                int n2 = y;
                sumPart2[n2] = sumPart2[n2] - classDistribution[x3 - 1][y];
                ++y;
            }
            if (!ClassifierUtils.hasSameClass(distribution1, distribution2)) {
                entropy = this.computeEntropy(sumPart1, totalSums[i]);
                double actualValue = (double)(values[x3 - 1] + values[x3]) / 2.0;
                numericData.addData(actualValue, resultGain[i] - (entropy += this.computeEntropy(sumPart2, totalSums[i])), sumPart1, sumPart2);
                if (minimumEntropy > entropy) {
                    minimumEntropy = entropy;
                    minimumValue = actualValue;
                }
            }
            ++x3;
        }
        if (minimumEntropy == 2.147483647E9) {
            resultGain[i] = 0.0;
        } else {
            int n = i;
            resultGain[n] = resultGain[n] - minimumEntropy;
            splitValues[i] = minimumValue;
        }
        numericDataList.add(numericData);
    }

    private float[] getDistinctSortedValues(ArrayList inst, int attIndex) {
        int size = inst.size();
        float[] instanceTemp = new float[size];
        int counter = 0;
        int x = 0;
        while (x < size) {
            Instance instance = this.getInstance(inst, x);
            if (!instance.isMissing(attIndex)) {
                instanceTemp[counter] = instance.getValue(attIndex);
                ++counter;
            }
            ++x;
        }
        size = counter;
        float[] distinctValues = new float[size];
        x = 0;
        while (x < size) {
            distinctValues[x] = instanceTemp[x];
            ++x;
        }
        Arrays.sort(distinctValues);
        ArrayList<Float> valuesTemp = new ArrayList<Float>();
        valuesTemp.add(Float.valueOf(distinctValues[0]));
        float lastValue = distinctValues[0];
        counter = 1;
        int x2 = 1;
        while (x2 < size) {
            if (distinctValues[x2] != lastValue) {
                valuesTemp.add(Float.valueOf(distinctValues[x2]));
                lastValue = distinctValues[x2];
                ++counter;
            }
            ++x2;
        }
        size = counter;
        distinctValues = new float[size];
        x2 = 0;
        while (x2 < size) {
            distinctValues[x2] = ((Float)valuesTemp.get(x2)).floatValue();
            ++x2;
        }
        return distinctValues;
    }

    public double computeEntropy(float[] classValues, float totalSum) {
        double entropy = 0.0;
        float sum = 0.0f;
        int size = classValues.length;
        int i = 0;
        while (i < size) {
            entropy -= this.xlog2(classValues[i]);
            sum += classValues[i];
            ++i;
        }
        return (entropy + this.xlog2(sum)) / (double)totalSum;
    }

    public double computeSplitInformation(SplitObject split, int splitAttIndex) throws Exception {
        Integer[] actualAtt = split.getAttributes();
        SplitObject[] splitData = this.splitData(split, splitAttIndex);
        Attribute splitAtt = this.instances.getAttribute(actualAtt[splitAttIndex]);
        int numValues = splitAtt.numValues();
        float numInstances = this.getNumberOfInstances(split);
        float totalNumInstancesSplit = 0.0f;
        double splitInfo = this.xlog2(numInstances);
        int i = 0;
        while (i < numValues) {
            float numInstancesSplit = this.getNumberOfInstances(splitData[i]);
            if (numInstancesSplit > 0.0f) {
                splitInfo -= this.xlog2(numInstancesSplit);
            }
            totalNumInstancesSplit += numInstancesSplit;
            ++i;
        }
        if (totalNumInstancesSplit < numInstances) {
            splitInfo -= this.xlog2(numInstances - totalNumInstancesSplit);
        }
        if ((splitInfo /= (double)numInstances) != 0.0) {
            return splitInfo;
        }
        return 1.0;
    }

    public float getNumberOfInstances(SplitObject split) {
        float numInstances = 0.0f;
        ArrayList actualInst = split.getInstances();
        int size = actualInst.size();
        int i = 0;
        while (i < size) {
            Instance instance = this.getInstance(actualInst, i);
            numInstances += instance.getWeight();
            ++i;
        }
        return numInstances;
    }

    public Instance getInstance(ArrayList inst, int i) {
        if (inst.get(i) instanceof Integer) {
            return this.instances.getInstance((Integer)inst.get(i));
        }
        return (Instance)inst.get(i);
    }

    public static boolean hasSameClass(float[] distribution1, float[] distribution2) {
        if (distribution1.length != distribution2.length) {
            return false;
        }
        int i = 0;
        while (i < distribution1.length) {
            if (distribution1[i] == 0.0f && distribution2[i] != 0.0f) {
                return false;
            }
            if (distribution1[i] != 0.0f && distribution1[i] == 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double log2(double a) {
        return Math.log(a) / LN2;
    }

    public static double sumNonClassDistribution(float[] distribution, int classIndex) {
        int sum = 0;
        int i = 0;
        while (i < distribution.length) {
            if (i != classIndex) {
                sum = (int)((float)sum + distribution[i]);
            }
            ++i;
        }
        return sum;
    }
}

