/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Saver;

public class ArffSaver
extends Saver {
    protected PrintWriter writer;
    private int numAttributes;
    private int counter = -1;
    private int[] selectedAttributes;
    private boolean counterAttribute;

    public ArffSaver(File output, InstanceSet instanceSet, int[] selectedAttributes) throws IOException {
        this(output, instanceSet, selectedAttributes, false);
    }

    public ArffSaver(File output, InstanceSet instanceSet, int[] selectedAttributes, boolean counterAttribute) throws IOException {
        this.writer = new PrintWriter((Writer)new FileWriter(output), true);
        this.selectedAttributes = selectedAttributes;
        this.instanceSet = instanceSet;
        this.counterAttribute = counterAttribute;
        this.numInstances = instanceSet.numInstances();
        this.numAttributes = selectedAttributes.length;
        this.writeHeader();
    }

    public ArffSaver(File output, InstanceSet instanceSet) throws IOException {
        this(output, instanceSet, false);
    }

    public ArffSaver(File output, InstanceSet instanceSet, boolean counterAttribute) throws IOException {
        int numSelAtt = instanceSet.numAttributes();
        int[] selAtt = new int[numSelAtt];
        int i = 0;
        while (i < numSelAtt) {
            selAtt[i] = i;
            ++i;
        }
        this.writer = new PrintWriter((Writer)new FileWriter(output), true);
        this.instanceSet = instanceSet;
        this.selectedAttributes = selAtt;
        this.counterAttribute = counterAttribute;
        this.numInstances = instanceSet.numInstances();
        this.numAttributes = this.selectedAttributes.length;
        this.writeHeader();
    }

    protected void writeHeader() throws IOException {
        this.writer.print("@relation " + this.instanceSet.getRelationName() + "\n\n");
        int i = 0;
        while (i < this.numAttributes) {
            this.writer.print(this.instanceSet.getAttribute(this.selectedAttributes[i]) + "\n");
            ++i;
        }
        if (this.counterAttribute) {
            this.writer.print("@attribute " + this.instanceSet.getCounterAttributeName() + " numeric\n");
        }
        this.writer.print("\n@data\n");
    }

    public boolean setInstance() throws IOException {
        ++this.counter;
        if (this.counter != this.numInstances) {
            Instance instance = this.instanceSet.getInstance(this.counter);
            int i = 0;
            while (i < this.numAttributes) {
                if (i > 0) {
                    this.writer.print(",");
                }
                this.writer.print(instance.stringValue(this.selectedAttributes[i]));
                ++i;
            }
            if (this.counterAttribute) {
                this.writer.print("," + instance.getWeight());
            }
            this.writer.println();
            return true;
        }
        this.writer.flush();
        this.writer.close();
        return false;
    }
}

