/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.clustering;

import unbbayes.datamining.clustering.Clustering;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Utils;

public class SimpleKMeans
extends Clustering {
    private InstanceSet centroids;
    private InstanceSet clustersStdDev;
    private int[] clustersSize;
    private double[] minValue;
    private double[] maxValue;
    private int iterations = 0;
    private double[] squaredErrors;

    public SimpleKMeans(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }

    public void run() throws Exception {
        int j;
        this.iterations = 0;
        InstanceSet instances = new InstanceSet(this.instanceSet);
        this.minValue = new double[instances.numAttributes()];
        this.maxValue = new double[instances.numAttributes()];
        int i = 0;
        while (i < instances.numAttributes()) {
            this.maxValue[i] = Double.NaN;
            this.minValue[i] = Double.NaN;
            ++i;
        }
        this.centroids = new InstanceSet(instances, this.numClusters);
        this.assignmentMatrix = new int[instances.numInstances()];
        i = 0;
        while (i < instances.numInstances()) {
            this.updateMinMax(instances.getInstance(i));
            ++i;
        }
        this.numClusters = this.centroids.numInstances();
        boolean converged = false;
        InstanceSet[] tempI = new InstanceSet[this.numClusters];
        this.squaredErrors = new double[this.numClusters];
        while (!converged) {
            int emptyClusterCount = 0;
            ++this.iterations;
            converged = true;
            i = 0;
            while (i < instances.numInstances()) {
                Instance toCluster = instances.getInstance(i);
                int newC = this.clusterProcessedInstance(toCluster, true);
                if (newC != this.assignmentMatrix[i]) {
                    converged = false;
                }
                this.assignmentMatrix[i] = newC;
                ++i;
            }
            this.centroids = new InstanceSet(instances, this.numClusters);
            i = 0;
            while (i < this.numClusters) {
                tempI[i] = new InstanceSet(instances, 0);
                ++i;
            }
            i = 0;
            while (i < instances.numInstances()) {
                tempI[this.assignmentMatrix[i]].insertInstance(instances.getInstance(i));
                ++i;
            }
            i = 0;
            while (i < this.numClusters) {
                float[] vals = new float[this.numAttributes + 1];
                if (tempI[i].numInstances() == 0) {
                    ++emptyClusterCount;
                } else {
                    j = 0;
                    while (j < this.numAttributes) {
                        vals[j] = (float)tempI[i].meanOrMode(j);
                        ++j;
                    }
                    vals[this.numAttributes] = 1.0f;
                    this.centroids.insertInstance(vals);
                }
                ++i;
            }
            if (emptyClusterCount > 0) {
                this.numClusters -= emptyClusterCount;
                tempI = new InstanceSet[this.numClusters];
            }
            if (converged) continue;
            this.squaredErrors = new double[this.numClusters];
        }
        this.clustersStdDev = new InstanceSet(instances, this.numClusters);
        this.clustersSize = new int[this.numClusters];
        i = 0;
        while (i < this.numClusters) {
            float[] vals2 = new float[this.numAttributes + 1];
            j = 0;
            while (j < this.numAttributes) {
                vals2[j] = instances.getAttribute(j).isNumeric() ? (float)Math.sqrt(tempI[i].variance(j)) : Instance.missingValue();
                ++j;
            }
            vals2[this.numAttributes] = 1.0f;
            this.clustersStdDev.insertInstance(vals2);
            this.clustersSize[i] = tempI[i].numInstances();
            ++i;
        }
    }

    private int clusterProcessedInstance(Instance instance, boolean updateErrors) {
        double minDist = 2.147483647E9;
        int bestCluster = 0;
        int i = 0;
        while (i < this.numClusters) {
            double dist = this.distance(instance, this.centroids.getInstance(i));
            if (dist < minDist) {
                minDist = dist;
                bestCluster = i;
            }
            ++i;
        }
        if (updateErrors) {
            int n = bestCluster;
            this.squaredErrors[n] = this.squaredErrors[n] + minDist;
        }
        return bestCluster;
    }

    public int clusterInstance(Instance instance) throws Exception {
        return this.clusterProcessedInstance(instance, false);
    }

    private double distance(Instance first, Instance second) {
        double distance = 0.0;
        int p1 = 0;
        int p2 = 0;
        while (p1 < this.numInstances || p2 < this.numInstances) {
            double diff;
            int secondI;
            int firstI = p1 >= this.numInstances ? this.centroids.numAttributes() : p1;
            if (firstI == (secondI = p2 >= this.numInstances ? this.centroids.numAttributes() : p2)) {
                diff = this.difference(firstI, first.getValue(p1), second.getValue(p2));
                ++p1;
                ++p2;
            } else if (firstI > secondI) {
                diff = this.difference(secondI, 0.0, second.getValue(p2));
                ++p2;
            } else {
                diff = this.difference(firstI, first.getValue(p1), 0.0);
                ++p1;
            }
            distance += diff * diff;
        }
        return distance;
    }

    private double difference(int index, double val1, double val2) {
        return this.norm(val1, index) - this.norm(val2, index);
    }

    private double norm(double x, int i) {
        if (Double.isNaN(this.minValue[i]) || Utils.eq(this.maxValue[i], this.minValue[i])) {
            return 0.0;
        }
        return (x - this.minValue[i]) / (this.maxValue[i] - this.minValue[i]);
    }

    private void updateMinMax(Instance instance) {
        int j = 0;
        while (j < this.centroids.numAttributes()) {
            if (Double.isNaN(this.minValue[j])) {
                this.minValue[j] = instance.getValue(j);
                this.maxValue[j] = instance.getValue(j);
            } else if ((double)instance.getValue(j) < this.minValue[j]) {
                this.minValue[j] = instance.getValue(j);
            } else if ((double)instance.getValue(j) > this.maxValue[j]) {
                this.maxValue[j] = instance.getValue(j);
            }
            ++j;
        }
    }

    public void setNumClusters(int numClusters) throws Exception {
        if (numClusters <= 0) {
            throw new Exception("Number of clusters must be > 0");
        }
        this.numClusters = numClusters;
    }

    public InstanceSet getClusterCentroids() {
        return this.centroids;
    }

    public InstanceSet getClusterStandardDevs() {
        return this.clustersStdDev;
    }

    public double getSquaredError() {
        return Utils.sum(this.squaredErrors);
    }

    public int[] getClusterSizes() {
        return this.clustersSize;
    }
}

