/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.clustering;

import java.util.Arrays;
import java.util.Random;
import unbbayes.datamining.clustering.Clustering;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.distance.IDistance;

public class Kmeans
extends Clustering {
    private float[][] centroids;
    private double[][] distanceMatrix;
    private IDistance distance;
    private double error;

    public Kmeans(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }

    protected void run() throws Exception {
        boolean go;
        if (this.numNumericAttributes < 1) {
            throw new Exception("K-means needs at least one numeric attribute");
        }
        double localError = Double.MAX_VALUE;
        double instantError = Double.MAX_VALUE;
        this.centroids = this.initialize();
        int count1 = 0;
        int count2 = 0;
        do {
            go = false;
            this.distanceMatrix = this.calculateDistanceMatrix();
            this.assignmentMatrix = this.assignPoints();
            ++count1;
            this.centroids = this.calculateCentroids();
            instantError = this.calculateError();
            if (instantError != 0.0 && Double.compare(this.error, localError / instantError) < 0) {
                localError = instantError;
                go = true;
            }
            ++count2;
        } while (go);
    }

    private float[][] initialize() {
        float[][] centroids = new float[this.numClusters][this.numNumericAttributes];
        float[] candidate = new float[this.numNumericAttributes];
        Random randomizer = new Random();
        int filled = 0;
        int numInstancesIDs = this.numInstances;
        int[] instancesIDsAux = (int[])this.instancesIDs.clone();
        int classIndex = this.instanceSet.classIndex;
        while (filled < this.numClusters && numInstancesIDs > 0) {
            int instIDs = randomizer.nextInt(numInstancesIDs);
            int inst = instancesIDsAux[instIDs];
            int attIndex = 0;
            int att = 0;
            while (att < this.numAttributes) {
                if (this.instanceSet.attributeType[att] == 0 && this.instanceSet.attributeType[att] != classIndex) {
                    candidate[attIndex] = this.instances[inst].data[att];
                    ++attIndex;
                }
                ++att;
            }
            boolean exists = false;
            int c = 0;
            while (c < filled) {
                int countEqualAttribs = 0;
                int att2 = 0;
                while (att2 < this.numNumericAttributes) {
                    if (centroids[c][att2] == candidate[att2]) {
                        ++countEqualAttribs;
                    }
                    ++att2;
                }
                if (countEqualAttribs == this.numNumericAttributes) {
                    exists = true;
                    break;
                }
                ++c;
            }
            if (exists) {
                int lastID;
                instancesIDsAux[instIDs] = lastID = instancesIDsAux[numInstancesIDs - 1];
                --numInstancesIDs;
                continue;
            }
            att = 0;
            while (att < this.numNumericAttributes) {
                centroids[filled][att] = candidate[att];
                ++att;
            }
            ++filled;
        }
        return centroids;
    }

    private double[][] calculateDistanceMatrix() {
        double[][] distanceMatrix = new double[this.numClusters][this.numInstances];
        float[] instance = new float[this.numNumericAttributes];
        int clusterIndex = 0;
        while (clusterIndex < this.numClusters) {
            int i = 0;
            while (i < this.numInstances) {
                int inst = this.instancesIDs[i];
                int attIndex = 0;
                int att = 0;
                while (att < this.numAttributes) {
                    if (this.attributeType[att] == 0) {
                        instance[attIndex] = this.instances[inst].data[att];
                        ++attIndex;
                    }
                    ++att;
                }
                float[] centroid = this.centroids[clusterIndex];
                float dist = this.distance.distanceValue(centroid, instance);
                if (Float.isNaN(dist)) {
                    boolean bl = true;
                }
                distanceMatrix[clusterIndex][i] = dist;
                ++i;
            }
            ++clusterIndex;
        }
        return distanceMatrix;
    }

    private int[] assignPoints() {
        int[] assignmentMatrix = new int[this.instanceSet.numInstances];
        int selectedCluster = -999;
        Arrays.fill(assignmentMatrix, -1);
        if (this.numClusters == 0) {
            return assignmentMatrix;
        }
        int i = 0;
        while (i < this.numInstances) {
            int inst = this.instancesIDs[i];
            double least = Double.MAX_VALUE;
            int clusterIndex = 0;
            while (clusterIndex < this.numClusters) {
                if (this.distanceMatrix[clusterIndex][i] < least) {
                    least = this.distanceMatrix[clusterIndex][i];
                    selectedCluster = clusterIndex;
                }
                ++clusterIndex;
            }
            assignmentMatrix[inst] = selectedCluster;
            ++i;
        }
        return assignmentMatrix;
    }

    private float[][] calculateCentroids() {
        float[][] centroidsAux = new float[this.numClusters][this.numNumericAttributes];
        float[] sum = new float[this.numNumericAttributes];
        boolean deleteAny = false;
        boolean[] deleteIndex = new boolean[this.numClusters];
        Arrays.fill(deleteIndex, false);
        int clusterIndex = 0;
        while (clusterIndex < this.numClusters) {
            Arrays.fill(sum, 0.0f);
            int membersCounter = 0;
            int i = 0;
            while (i < this.numInstances) {
                int inst = this.instancesIDs[i];
                if (this.assignmentMatrix[inst] == clusterIndex) {
                    float weight = this.instances[inst].data[this.counterIndex];
                    membersCounter = (int)((float)membersCounter + weight);
                    int attIndex = 0;
                    int att = 0;
                    while (att < this.numAttributes) {
                        if (this.attributeType[att] == 0) {
                            int n = attIndex++;
                            sum[n] = sum[n] + this.instances[inst].data[att] * weight;
                        }
                        ++att;
                    }
                }
                ++i;
            }
            if (membersCounter == 0) {
                deleteIndex[clusterIndex] = true;
                deleteAny = true;
            } else {
                int att = 0;
                while (att < this.numNumericAttributes) {
                    centroidsAux[clusterIndex][att] = sum[att] / (float)membersCounter;
                    ++att;
                }
            }
            ++clusterIndex;
        }
        if (deleteAny) {
            this.removeEmptyCluster(deleteIndex);
        }
        return centroidsAux;
    }

    private void removeEmptyCluster(boolean[] deleteIndex) {
        int deleteCount = 0;
        int clusterId = 0;
        while (clusterId < this.numClusters) {
            if (deleteIndex[clusterId]) {
                ++deleteCount;
            }
            ++clusterId;
        }
        int newNumClusters = this.numClusters - deleteCount;
        float[][] centroidsAux = new float[newNumClusters][];
        double[][] distanceMatrixAux = new double[newNumClusters][];
        int index = 0;
        int clusterId2 = 0;
        while (clusterId2 < this.numClusters) {
            if (!deleteIndex[clusterId2]) {
                centroidsAux[index] = this.centroids[clusterId2];
                distanceMatrixAux[index] = this.distanceMatrix[clusterId2];
                ++index;
            }
            ++clusterId2;
        }
        this.numClusters = newNumClusters;
        this.distanceMatrix = this.calculateDistanceMatrix();
        this.assignmentMatrix = this.assignPoints();
    }

    private double calculateError() {
        double result = 0.0;
        float[] instance = new float[this.numNumericAttributes];
        int clusterIndex = 0;
        while (clusterIndex < this.numClusters) {
            int i = 0;
            while (i < this.numInstances) {
                int inst = this.instancesIDs[i];
                if (this.assignmentMatrix[inst] == clusterIndex) {
                    int attIndex = 0;
                    int att = 0;
                    while (att < this.numAttributes) {
                        if (this.attributeType[att] == 0) {
                            instance[attIndex] = this.instances[inst].data[att];
                            ++attIndex;
                        }
                        ++att;
                    }
                    result += Math.pow(this.distance.distanceValue(instance, this.centroids[clusterIndex]), 2.0);
                }
                ++i;
            }
            ++clusterIndex;
        }
        return result;
    }

    public void setNumClusters(int numClusters) {
        this.numClusters = numClusters;
    }

    public void setError(double error) {
        this.error = error;
    }

    public void setOptionDistance(IDistance distance) {
        this.distance = distance;
    }

    public float[][] getCentroids() {
        return this.centroids;
    }
}

