/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.clustering;

import java.util.ArrayList;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;

public abstract class Clustering {
    protected InstanceSet instanceSet;
    protected Instance[] instances;
    protected int numInstances;
    protected int numAttributes;
    protected int numNumericAttributes;
    protected int numNominalAttributes;
    protected int numCyclicAttributes;
    protected byte[] attributeType;
    protected static final byte NUMERIC = 0;
    protected static final byte NOMINAL = 1;
    protected static final byte CYCLIC = 2;
    protected int counterIndex;
    protected int[] instancesIDs;
    protected int[][] clusters;
    protected int numClusters = 0;
    protected double[] clustersSize;
    protected int[] assignmentMatrix;

    private void initialize() {
        this.instances = this.instanceSet.instances;
        this.numInstances = this.instanceSet.numInstances;
        this.numAttributes = this.instanceSet.numAttributes;
        this.numNumericAttributes = this.instanceSet.numNumericAttributes;
        this.numNominalAttributes = this.instanceSet.numNominalAttributes;
        this.numCyclicAttributes = this.instanceSet.numCyclicAttributes;
        this.counterIndex = this.instanceSet.counterIndex;
        this.attributeType = this.instanceSet.attributeType;
        this.clusters = null;
        this.clustersSize = null;
        this.assignmentMatrix = null;
    }

    public void clusterize() throws Exception {
        this.initialize();
        this.instancesIDs = new int[this.numInstances];
        int i = 0;
        while (i < this.numInstances) {
            this.instancesIDs[i] = i;
            ++i;
        }
        this.run();
        this.buildClustersInfo();
    }

    public void clusterize(int[] instancesIDs) throws Exception {
        this.instancesIDs = instancesIDs;
        this.initialize();
        this.numInstances = instancesIDs.length;
        this.run();
        this.buildClustersInfo();
    }

    public void clusterize(int classValue) throws Exception {
        this.initialize();
        int counter = 0;
        int[] instancesIDsTmp = new int[this.numInstances];
        int classIndex = this.instanceSet.classIndex;
        int inst = 0;
        while (inst < this.numInstances) {
            if (this.instances[inst].data[classIndex] == (float)classValue) {
                instancesIDsTmp[counter] = inst;
                ++counter;
            }
            ++inst;
        }
        this.instancesIDs = new int[counter];
        int i = 0;
        while (i < counter) {
            this.instancesIDs[i] = instancesIDsTmp[i];
            ++i;
        }
        this.numInstances = counter;
        this.run();
        this.buildClustersInfo();
    }

    public void buildClustersInfo() throws Exception {
        int i;
        int clusterQtd;
        if (this.numClusters < 1) {
            throw new IllegalArgumentException("Number of cluster is less than 1!");
        }
        if (this.assignmentMatrix == null) {
            throw new IllegalArgumentException("The assignmentMatrix is null!");
        }
        if (this.clusters == null) {
            this.clusters = new int[this.numClusters][];
            ArrayList[] clustersTemp = new ArrayList[this.numClusters];
            int clusterID = 0;
            while (clusterID < this.numClusters) {
                clustersTemp[clusterID] = new ArrayList();
                ++clusterID;
            }
            int inst = 0;
            while (inst < this.assignmentMatrix.length) {
                clusterID = this.assignmentMatrix[inst];
                if (clusterID != -1) {
                    clustersTemp[clusterID].add(inst);
                }
                ++inst;
            }
            clusterID = 0;
            while (clusterID < this.numClusters) {
                clusterQtd = clustersTemp[clusterID].size();
                this.clusters[clusterID] = new int[clusterQtd];
                i = 0;
                while (i < clusterQtd) {
                    int inst2;
                    this.clusters[clusterID][i] = inst2 = ((Integer)clustersTemp[clusterID].get(i)).intValue();
                    ++i;
                }
                ++clusterID;
            }
        }
        if (this.clustersSize == null) {
            this.clustersSize = new double[this.numClusters];
            int clusterID = 0;
            while (clusterID < this.numClusters) {
                clusterQtd = this.clusters[clusterID].length;
                int clusterSize = 0;
                i = 0;
                while (i < clusterQtd) {
                    int inst = this.clusters[clusterID][i];
                    clusterSize = (int)((float)clusterSize + this.instances[inst].data[this.counterIndex]);
                    ++i;
                }
                this.clustersSize[clusterID] = clusterSize;
                ++clusterID;
            }
        }
    }

    protected abstract void run() throws Exception;

    public int[][] getClusters() {
        return this.clusters;
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public double[] getClustersSize() {
        return this.clustersSize;
    }

    public int[] getAssignmentMatrix() {
        return this.assignmentMatrix;
    }
}

