/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.clustering;

import unbbayes.datamining.clustering.Clustering;
import unbbayes.datamining.clustering.Squeezer;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;

public class CEBMDC
extends Clustering {
    double[] weight;
    double s;
    private int[] numericClusters;
    private int[] nominalClusters;
    private boolean useAverageSimilarity;

    public CEBMDC(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }

    protected void run() throws Exception {
        InstanceSet mixedData = this.buildMixedMatrix();
        Squeezer squeezer = new Squeezer(mixedData);
        squeezer.setS(this.s);
        squeezer.setUseAverageSimilarity(this.useAverageSimilarity);
        squeezer.setWeight(this.weight);
        squeezer.clusterize(this.instancesIDs);
        this.clusters = squeezer.clusters;
        this.numClusters = squeezer.numClusters;
        this.clustersSize = squeezer.clustersSize;
        this.assignmentMatrix = squeezer.assignmentMatrix;
    }

    private InstanceSet buildMixedMatrix() {
        boolean exception = false;
        String exceptionMsg = "The numeric and nominal clusters are not from the same instances!";
        if (this.numericClusters.length != this.nominalClusters.length || this.numericClusters.length != this.numInstances || this.nominalClusters.length != this.numInstances) {
            exception = true;
        } else {
            int i = 0;
            while (i < this.numInstances) {
                if (this.numericClusters[i] == -1 && this.nominalClusters[i] != -1) {
                    exception = true;
                }
                if (this.numericClusters[i] != -1 && this.nominalClusters[i] == -1) {
                    exception = true;
                }
                ++i;
            }
        }
        if (exception) {
            throw new IllegalArgumentException(exceptionMsg);
        }
        int counter = 0;
        int i = 0;
        while (i < this.numInstances) {
            if (this.numericClusters[i] != -1) {
                ++counter;
            }
            ++i;
        }
        this.instancesIDs = new int[counter];
        this.numInstances = this.numericClusters.length;
        int inst = 0;
        int i2 = 0;
        while (i2 < this.numInstances) {
            if (this.numericClusters[i2] != -1) {
                this.instancesIDs[inst] = i2;
                ++inst;
            }
            ++i2;
        }
        Attribute[] newAttributes = new Attribute[]{new Attribute("", 0, false, 0, 0), new Attribute("", 0, false, 0, 1)};
        InstanceSet mixedData = new InstanceSet(this.numInstances, newAttributes);
        int i3 = 0;
        while (i3 < this.numInstances) {
            float[] instance = new float[]{this.numericClusters[i3], this.nominalClusters[i3], this.instances[i3].data[this.counterIndex]};
            mixedData.insertInstance(instance);
            ++i3;
        }
        mixedData.numNominalAttributes = 2;
        mixedData.attributeType[0] = 1;
        mixedData.attributeType[1] = 1;
        return mixedData;
    }

    public void setWeight(double[] weight) {
        this.weight = weight;
    }

    public void setS(double s) {
        this.s = s;
    }

    public void setNumericClustersInput(int[] numericClusters) {
        this.numericClusters = numericClusters;
    }

    public void setNominalClustersInput(int[] nominalClusters) {
        this.nominalClusters = nominalClusters;
    }

    public void setUseAverageSimilarity(boolean useAverageSimilarity) {
        this.useAverageSimilarity = useAverageSimilarity;
    }
}

