/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers.neuralnetwork;

import java.io.Serializable;
import unbbayes.datamining.classifiers.neuralnetwork.ActivationFunction;
import unbbayes.datamining.datamanipulation.Utils;

public class Sigmoid
implements ActivationFunction,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final double MIN_STEEP = 0.0;
    public static final double DEF_STEEP = 1.0;
    private double steep;

    public Sigmoid() {
        this.steep = 1.0;
    }

    public Sigmoid(double steep) {
        this.steep = steep;
    }

    public void setSteep(float steep) {
        if ((double)steep > 0.0) {
            this.steep = steep;
        }
    }

    public double getSteep() {
        return this.steep;
    }

    public double functionValue(double v) {
        return 1.0 / (1.0 + Math.exp(-this.steep * v));
    }

    public double outputErrorTerm(double desiredOutput, double actualOutput) {
        return this.steep * (desiredOutput - actualOutput) * actualOutput * (1.0 - actualOutput);
    }

    public double hiddenErrorTerm(double y, double sum) {
        return this.steep * y * (1.0 - y) * sum;
    }

    public float normalizeToFunctionInterval(float data, float dataHighestValue, float dataLowestValue) {
        return Utils.normalize(data, dataHighestValue, dataLowestValue, 1.0f, 0.0f);
    }
}

