/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers.decisiontree;

import java.util.ArrayList;
import javax.swing.JTree;
import unbbayes.datamining.classifiers.Classifier;
import unbbayes.datamining.classifiers.decisiontree.Leaf;
import unbbayes.datamining.classifiers.decisiontree.Node;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DecisionTreeLearning
extends Classifier {
    protected float threshold = -1.0f;
    protected int positiveClass = 1;

    protected abstract void makeTree(InstanceSet var1) throws Exception;

    public abstract JTree getTree();

    public abstract String toString();

    @Override
    public float[] distributionForInstance(Instance instance) {
        Leaf leaf = this.classifyInstanceAux(instance);
        float[] dist = leaf.getDistribution();
        int numClasses = dist.length;
        float[] probs = new float[numClasses];
        float sum = Utils.sum(dist);
        int i = 0;
        while (i < numClasses) {
            double aux = dist[i] + 1.0f;
            probs[i] = (float)(aux /= (double)(sum + (float)numClasses));
            ++i;
        }
        return probs;
    }

    @Override
    public int classifyInstance(Instance instance) {
        return this.classifyInstanceAux(instance).getClassValue();
    }

    protected abstract Leaf classifyInstanceAux(Instance var1);

    public void descendTree(Node treeNode, int[] count, ArrayList<float[]> positivePoints, ArrayList<float[]> negativePoints, ArrayList<float[]> probs) {
        int tp = 0;
        int fp = 0;
        if (treeNode.children.get(0) instanceof Leaf) {
            int leafClass;
            Leaf leaf = (Leaf)treeNode.children.get(0);
            int matched = leaf.getMatched();
            int errors = leaf.getErrors();
            tp = matched - errors;
            fp = errors;
            int n = leafClass = leaf.getClassValue();
            count[n] = count[n] + tp;
            float[] point = new float[2];
            if (leafClass == this.positiveClass) {
                point[0] = fp;
                point[1] = tp;
                positivePoints.add(point);
            } else {
                point[0] = tp;
                point[1] = fp;
                negativePoints.add(point);
            }
            float[] prob = new float[]{(float)matched / (float)(matched + errors), leafClass};
        } else {
            int numChildren = treeNode.children.size();
            int i = 0;
            while (i < numChildren) {
                this.descendTree((Node)treeNode.children.get(i), count, positivePoints, negativePoints, probs);
                ++i;
            }
        }
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public void setPositiveClass(int positiveClass) {
        this.positiveClass = positiveClass;
    }
}

