/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers.cnmentities;

import java.io.Serializable;
import unbbayes.datamining.classifiers.cnmentities.OutputNeuron;

public class Combination
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String key;
    private OutputNeuron[] outputArray;

    public Combination(String key) {
        this.key = key;
    }

    public Combination(String key, OutputNeuron[] outputArray) {
        this.key = key;
        this.outputArray = outputArray;
    }

    public String getKey() {
        return this.key;
    }

    public OutputNeuron[] getOutputArray() {
        return this.outputArray;
    }

    public OutputNeuron getOutputNeuron(int index) {
        return this.outputArray[index];
    }

    public void punish(int numOfInstances) {
        int outputNum = this.outputArray.length;
        int sum = 0;
        int i = 0;
        while (i < outputNum) {
            if (this.outputArray[i] != null) {
                int j = 0;
                while (j < outputNum) {
                    if (this.outputArray[j] != null && i != j) {
                        sum += this.outputArray[j].accumulator;
                    }
                    ++j;
                }
                this.outputArray[i].setNetWeight(this.outputArray[i].accumulator - sum);
                this.outputArray[i].setConfidence((float)this.outputArray[i].accumulator * 100.0f / (float)(sum + this.outputArray[i].accumulator));
                this.outputArray[i].setSupport((float)this.outputArray[i].accumulator * 100.0f / (float)numOfInstances);
            }
            sum = 0;
            ++i;
        }
    }

    public void prunning(int threshold) {
        int outputNum = this.outputArray.length;
        int i = 0;
        while (i < outputNum) {
            if (this.outputArray[i] != null && this.outputArray[i].netWeight < threshold) {
                this.outputArray[i] = null;
            }
            ++i;
        }
    }

    public void prunning(int minSupport, int minConfidence) {
        int outputNum = this.outputArray.length;
        int i = 0;
        while (i < outputNum) {
            if (this.outputArray[i] != null && (this.outputArray[i].support < (float)minSupport || this.outputArray[i].confidence < (float)minConfidence)) {
                this.outputArray[i] = null;
            }
            ++i;
        }
    }

    public boolean isNull() {
        int outputNum = this.outputArray.length;
        int i = 0;
        while (i < outputNum) {
            if (this.outputArray[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void increaseAccumulator(int classValue, int weight) {
        if (this.outputArray[classValue] != null) {
            this.outputArray[classValue].increaseAccumulator(weight);
        } else {
            this.outputArray[classValue] = new OutputNeuron(weight);
        }
    }
}

