/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.swing.JComponent;

public class PrintNet
implements Printable,
Pageable {
    protected JComponent net;
    protected PageFormat pageFormat;
    protected Rectangle rect;
    protected String title;

    public PrintNet(String title, JComponent net, Rectangle rect, PageFormat pf) {
        this.net = net;
        this.title = title;
        this.pageFormat = pf;
        this.rect = rect;
    }

    public int print(Graphics g, PageFormat pf, int index) {
        if (index == 0) {
            this.paintComponent(g);
            return 0;
        }
        return 1;
    }

    protected void paintComponent(Graphics g) {
        double scaleX = this.pageFormat.getImageableWidth() / (double)this.rect.width;
        double scaleY = (this.pageFormat.getImageableHeight() - 30.0) / (double)this.rect.height;
        double scaleFactor = Math.min(Math.min(scaleX, scaleY), 1.0);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clipRect = g2.getClipBounds();
        AffineTransform at = g2.getTransform();
        int x = (int)this.pageFormat.getImageableX();
        int y = (int)this.pageFormat.getImageableY();
        g.drawString(this.title, x, y + 15);
        g2.translate((double)x - this.rect.getX(), (double)y - this.rect.getY() + 30.0);
        g2.setClip(this.rect);
        g2.scale(scaleFactor, scaleFactor);
        this.net.paint(g);
        g2.setTransform(at);
        g2.setClip(clipRect);
    }

    public int getNumberOfPages() {
        return 1;
    }

    public Printable getPrintable(int index) {
        return this;
    }

    public PageFormat getPageFormat(int index) {
        return this.pageFormat;
    }
}

