/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import unbbayes.gui.MSBNWindow;
import unbbayes.gui.NetworkWindow;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.msbn.SingleAgentMSBN;
import unbbayes.prs.msbn.SubNetwork;

public class MSBNController {
    private SingleAgentMSBN msbn;
    private MSBNWindow window;
    private NetworkWindow active;

    public MSBNController(SingleAgentMSBN msbn) {
        this.msbn = msbn;
        this.window = new MSBNWindow(msbn);
        this.init();
        this.addListeners();
    }

    private JTree makeJTree() {
        MutableTreeNode node = this.getTreeNode(this.msbn.getNetAt(0));
        JTree tree = new JTree(node, true);
        tree.setToggleClickCount(Integer.MAX_VALUE);
        int i = 0;
        while (i < tree.getRowCount()) {
            tree.expandRow(i);
            ++i;
        }
        this.addTreeMouseListener(tree);
        return tree;
    }

    private MutableTreeNode getTreeNode(SubNetwork net) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(net);
        int i = net.getAdjacentsSize() - 1;
        while (i >= 0) {
            node.add(this.getTreeNode(net.getAdjacentAt(i)));
            --i;
        }
        return node;
    }

    private void addTreeMouseListener(final JTree tree) {
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getModifiers() == 16) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                    SubNetwork net = (SubNetwork)node.getUserObject();
                    if (net == MSBNController.this.active.getSingleEntityNetwork() || JOptionPane.showConfirmDialog(MSBNController.this.window, "Shift Attention?") != 0) {
                        return;
                    }
                    try {
                        NetworkWindow netWindow = new NetworkWindow(net);
                        MSBNController.this.changeActive(netWindow);
                        MSBNController.this.msbn.shiftAttention(net);
                        netWindow.changeToPNCompilationPane();
                        tree.scrollRowToVisible(selRow);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        tree.addMouseListener(ml);
    }

    public JInternalFrame getPanel() {
        return this.window;
    }

    private void init() {
        this.window.getNetList().setSelectedIndex(0);
        if (this.msbn.getNetCount() > 0) {
            this.changeActive(new NetworkWindow(this.msbn.getNetAt(0)));
        }
    }

    private void changeActive(NetworkWindow newWindow) {
        if (this.active != null) {
            SingleEntityNetwork net = this.active.getSingleEntityNetwork();
            int i = 0;
            while (i < net.getNodeCount()) {
                net.getNodeAt(i).setSelected(false);
                ++i;
            }
            this.window.getContentPane().remove(this.active.getContentPane());
        }
        this.active = newWindow;
        if (newWindow == null) {
            return;
        }
        this.active.getNetWindowEdition().getBtnCompile().setVisible(false);
        this.active.getNetWindowCompilation().getEditMode().setVisible(false);
        this.window.getContentPane().add((Component)this.active.getContentPane(), "Center");
        this.window.updateUI();
    }

    private void addListeners() {
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 16) {
                    int index = MSBNController.this.window.getNetList().locationToIndex(e.getPoint());
                    if (index < 0 || MSBNController.this.window.getNetList().getModel().getElementAt(index) == MSBNController.this.active.getSingleEntityNetwork()) {
                        return;
                    }
                    NetworkWindow netWindow = new NetworkWindow(MSBNController.this.msbn.getNetAt(index));
                    MSBNController.this.changeActive(netWindow);
                }
            }
        };
        this.window.addListMouseListener(mouseListener);
        this.window.addEditionActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MSBNController.this.active.changeToPNEditionPane();
                MSBNController.this.window.showBtnPanel(MSBNWindow.EDITION_PANE);
                MSBNController.this.window.changeToListView();
            }
        });
        final ActionListener newBtnAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MSBNController.this.msbn.addNetwork(new SubNetwork("new net " + MSBNController.this.msbn.getNetCount()));
                if (MSBNController.this.msbn.getNetCount() == 1) {
                    MSBNController.this.changeActive(new NetworkWindow(MSBNController.this.msbn.getNetAt(0)));
                }
                MSBNController.this.window.getNetList().updateUI();
            }
        };
        this.window.addNewBtnActionListener(newBtnAction);
        this.window.addRemoveBtnActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = MSBNController.this.window.getNetList().getSelectedIndex();
                if (index < 0) {
                    return;
                }
                MSBNController.this.msbn.remove(index);
                if (MSBNController.this.msbn.getNetCount() > 0) {
                    NetworkWindow netWindow = new NetworkWindow(MSBNController.this.msbn.getNetAt(0));
                    MSBNController.this.changeActive(netWindow);
                } else {
                    newBtnAction.actionPerformed(null);
                    MSBNController.this.changeActive(new NetworkWindow(MSBNController.this.msbn.getNetAt(0)));
                }
                MSBNController.this.window.getNetList().setSelectedIndex(0);
                MSBNController.this.window.getNetList().repaint();
            }
        });
        this.window.addCompileBtnActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    MSBNController.this.msbn.compile((SubNetwork)MSBNController.this.active.getSingleEntityNetwork());
                    MSBNController.this.active.changeToPNCompilationPane();
                    MSBNController.this.window.changeToTreeView(MSBNController.this.makeJTree());
                    MSBNController.this.window.showBtnPanel(MSBNWindow.COMPILED_PANE);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(MSBNController.this.window, e.getMessage(), "Compilation error", 0);
                    e.printStackTrace();
                }
            }
        });
    }
}

