/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import unbbayes.aprendizagem.OrdenationInterationController;
import unbbayes.prs.Node;
import unbbayes.prs.bn.LearningNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrdenationWindow
extends JDialog {
    private static final long serialVersionUID = 0L;
    private String[] metrics = new String[]{"MDL", "GH", "GHS"};
    private String[] paradigms = new String[]{"Ponctuation", "IC"};
    private String[] ponctuationAlgorithms = new String[]{"K2", "B"};
    private String[] icAlgorithms = new String[]{"CBL-A", "CBL-B"};
    private JPanel northPanel;
    private JPanel southPanel;
    private JPanel centerPanel;
    private JPanel buttonPanel;
    private JPanel ordenationPanel;
    private JPanel decisionPanel;
    public JProgressBar progress;
    public JLabel label;
    private JButton upButton;
    private JButton downButton;
    private JButton continueButton;
    private JButton relationsButton;
    private JList ordenationJL;
    private DefaultListModel listModel;
    private JComboBox algorithmsList;
    private JTextField txtParam;
    private JComboBox paradigmList;
    private JComboBox metricList;
    private ArrayList<Node> variables;
    private OrdenationInterationController ordenationController;
    ActionListener continueEvent = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            OrdenationWindow.this.ordenationController.continueEvent((String)OrdenationWindow.this.paradigmList.getSelectedItem(), (String)OrdenationWindow.this.algorithmsList.getSelectedItem(), (String)OrdenationWindow.this.metricList.getSelectedItem(), OrdenationWindow.this.txtParam.getText());
        }
    };
    ActionListener upEvent = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            OrdenationWindow.this.ordenationController.upEvent();
        }
    };
    ActionListener downEvent = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            OrdenationWindow.this.ordenationController.downEvent();
        }
    };
    ActionListener relationsEvent = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            OrdenationWindow.this.ordenationController.relationsEvent();
        }
    };
    MouseListener doubleClickEvent = new MouseListener(){

        public void mouseClicked(MouseEvent e) {
            OrdenationWindow.this.ordenationController.doubleClickEvent(e);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    };
    ItemListener paradigmEvent = new ItemListener(){

        public void itemStateChanged(ItemEvent ie) {
            OrdenationWindow.this.ordenationController.paradigmEvent(OrdenationWindow.this.paradigmList.getSelectedIndex());
        }
    };

    public OrdenationWindow(ArrayList<Node> variables) {
        super(new Frame(), "UnBBayes - Learning Module", true);
        this.variables = variables;
        Container container = this.getContentPane();
        container.add((Component)this.getCenterPanel(), "Center");
        container.add((Component)this.getSouthPanel(), "South");
        this.ordenationController = new OrdenationInterationController(variables, this);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    public OrdenationInterationController getController() {
        return this.ordenationController;
    }

    public JList getOrdenationJL() {
        return this.ordenationJL;
    }

    public JComboBox getMetricList() {
        return this.metricList;
    }

    public JComboBox getAlgorithmList() {
        return this.algorithmsList;
    }

    public int getIcSize() {
        return this.icAlgorithms.length;
    }

    public int getPonctuationSize() {
        return this.ponctuationAlgorithms.length;
    }

    public int getMetricsSize() {
        return this.metrics.length;
    }

    public String getIcAlgorithms(int index) {
        return this.icAlgorithms[index];
    }

    public String getPonctuatioAlgorithms(int index) {
        return this.ponctuationAlgorithms[index];
    }

    public String getMetrics(int index) {
        return this.metrics[index];
    }

    private JPanel getSouthPanel() {
        this.southPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        this.label = new JLabel("Variable : ");
        this.progress = new JProgressBar(0, 0, 100);
        this.progress.setStringPainted(true);
        this.southPanel.add(this.label);
        this.southPanel.add(this.progress);
        return this.southPanel;
    }

    private JPanel getCenterPanel() {
        this.centerPanel = new JPanel(new GridLayout(1, 2));
        this.centerPanel.add(this.getOrdenationPanel());
        this.centerPanel.add(this.getDecisionPanel());
        return this.centerPanel;
    }

    private JPanel getOrdenationPanel() {
        this.ordenationPanel = new JPanel(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.insertList();
        this.ordenationJL = new JList(this.listModel);
        JScrollPane ordenationJLScrollPane = new JScrollPane(this.ordenationJL);
        this.ordenationJL.setSelectionMode(0);
        this.ordenationJL.setSelectedIndex(0);
        this.ordenationPanel.add((Component)new JLabel("Ordenation"), "North");
        this.ordenationPanel.add((Component)ordenationJLScrollPane, "Center");
        this.ordenationJL.addMouseListener(this.doubleClickEvent);
        return this.ordenationPanel;
    }

    private JPanel getDecisionPanel() {
        this.decisionPanel = new JPanel(new BorderLayout());
        this.decisionPanel.add((Component)this.getNorthPanel(), "North");
        this.decisionPanel.add((Component)this.getButtonPanel(), "Center");
        return this.decisionPanel;
    }

    private JPanel getNorthPanel() {
        this.northPanel = new JPanel(new GridLayout(3, 2, 3, 3));
        this.paradigmList = new JComboBox<String>(this.paradigms);
        this.northPanel.add(new JLabel("Choose a Paradigm : "));
        this.northPanel.add(this.paradigmList);
        this.northPanel.add(new JLabel("Choose an Algorithm : "));
        this.algorithmsList = new JComboBox<String>(this.ponctuationAlgorithms);
        this.northPanel.add(this.algorithmsList);
        this.northPanel.add(new JLabel("Choose a Metric : "));
        this.metricList = new JComboBox<String>(this.metrics);
        this.northPanel.add(this.metricList);
        this.paradigmList.addItemListener(this.paradigmEvent);
        return this.northPanel;
    }

    private JPanel getButtonPanel() {
        this.buttonPanel = new JPanel(new GridLayout(8, 1, 5, 5));
        this.txtParam = new JTextField();
        this.upButton = new JButton("Up");
        this.downButton = new JButton("Down");
        this.continueButton = new JButton("Continue");
        this.relationsButton = new JButton("Relations");
        this.buttonPanel.add(this.upButton);
        this.buttonPanel.add(this.downButton);
        this.buttonPanel.add(this.relationsButton);
        this.buttonPanel.add(new JLabel("Parameter :"));
        this.buttonPanel.add(this.txtParam);
        this.buttonPanel.add(this.continueButton);
        this.continueButton.addActionListener(this.continueEvent);
        this.relationsButton.addActionListener(this.relationsEvent);
        this.upButton.addActionListener(this.upEvent);
        this.downButton.addActionListener(this.downEvent);
        return this.buttonPanel;
    }

    private void insertList() {
        int i = 0;
        while (i < this.variables.size()) {
            LearningNode aux = (LearningNode)this.variables.get(i);
            this.listModel.addElement(aux.getName());
            ++i;
        }
    }
}

