/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import unbbayes.aprendizagem.OptionsWindow;
import unbbayes.aprendizagem.OrdenationWindow;
import unbbayes.aprendizagem.RelationsWindow;
import unbbayes.prs.Node;
import unbbayes.prs.bn.LearningNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrdenationInterationController {
    private ArrayList<Node> variables;
    private OrdenationWindow frame;
    private String[] pamp;

    public OrdenationInterationController(ArrayList<Node> variables, OrdenationWindow frame) {
        this.variables = variables;
        this.frame = frame;
        this.pamp = new String[4];
    }

    public void upEvent() {
        JList ordenationJL = this.frame.getOrdenationJL();
        DefaultListModel listModel = (DefaultListModel)ordenationJL.getModel();
        ArrayList<Node> auxVector = new ArrayList<Node>();
        String auxName = (String)ordenationJL.getSelectedValue();
        LearningNode aux = null;
        int index = ordenationJL.getSelectedIndex();
        if (index != 0) {
            listModel.remove(index);
            listModel.add(--index, auxName);
            int i = 0;
            while (i < this.variables.size()) {
                aux = (LearningNode)this.variables.get(i);
                if (aux.getName().equals(auxName)) {
                    this.variables.remove(i);
                    int j = 0;
                    while (j < i - 1) {
                        auxVector.add(this.variables.get(j));
                        ++j;
                    }
                    auxVector.add(aux);
                    int k = i - 1;
                    while (k < this.variables.size()) {
                        auxVector.add(this.variables.get(k));
                        ++k;
                    }
                    this.variables = auxVector;
                    ordenationJL.setSelectedIndex(index);
                    break;
                }
                ++i;
            }
        }
    }

    public void downEvent() {
        JList ordenationJL = this.frame.getOrdenationJL();
        DefaultListModel listModel = (DefaultListModel)ordenationJL.getModel();
        ArrayList<Node> auxVector = new ArrayList<Node>();
        String auxName = (String)ordenationJL.getSelectedValue();
        LearningNode aux = null;
        int index = ordenationJL.getSelectedIndex();
        if (index < listModel.getSize() - 1) {
            listModel.remove(index);
            listModel.add(++index, auxName);
            int i = 0;
            while (i < this.variables.size()) {
                aux = (LearningNode)this.variables.get(i);
                if (aux.getName().equals(auxName)) {
                    this.variables.remove(i);
                    int j = 0;
                    while (j < i + 1) {
                        auxVector.add(this.variables.get(j));
                        ++j;
                    }
                    auxVector.add(aux);
                    int k = i + 1;
                    while (k < this.variables.size()) {
                        auxVector.add(this.variables.get(k));
                        ++k;
                    }
                    this.variables = auxVector;
                    ordenationJL.setSelectedIndex(index);
                    break;
                }
                ++i;
            }
        }
    }

    public String[] getPamp() {
        return this.pamp;
    }

    public void continueEvent(String p, String a, String m, String param) {
        this.pamp[0] = p;
        this.pamp[1] = a;
        this.pamp[2] = m;
        this.pamp[3] = param;
        this.frame.dispose();
    }

    public void relationsEvent() {
        new RelationsWindow(this.variables);
    }

    public void doubleClickEvent(MouseEvent e) {
        JList list;
        int nClick = e.getClickCount();
        if (nClick == 2 && !(list = (JList)e.getSource()).isSelectionEmpty()) {
            LearningNode aux = null;
            Object object = list.getSelectedValue();
            String name = object.toString();
            int i = 0;
            while (i < this.variables.size()) {
                aux = (LearningNode)this.variables.get(i);
                if (aux.getName().equals(name)) break;
                ++i;
            }
            new OptionsWindow(aux);
        }
    }

    public void paradigmEvent(int index) {
        JComboBox algorithmsList = this.frame.getAlgorithmList();
        algorithmsList.removeAllItems();
        JComboBox metricList = this.frame.getMetricList();
        metricList.removeAllItems();
        if (index == 0) {
            int i = 0;
            while (i < this.frame.getPonctuationSize()) {
                algorithmsList.addItem(this.frame.getPonctuatioAlgorithms(i));
                ++i;
            }
            i = 0;
            while (i < this.frame.getMetricsSize()) {
                metricList.addItem(this.frame.getMetrics(i));
                ++i;
            }
            metricList.setEnabled(true);
        } else if (index == 1) {
            int i = 0;
            while (i < this.frame.getIcSize()) {
                algorithmsList.addItem(this.frame.getIcAlgorithms(i));
                ++i;
            }
            metricList.setEnabled(false);
        }
    }

    public ArrayList<Node> getVariables() {
        return this.variables;
    }
}

