/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem;

import java.util.ArrayList;
import unbbayes.aprendizagem.K2Toolkit;
import unbbayes.prs.Node;
import unbbayes.prs.bn.LearningNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class K2
extends K2Toolkit {
    private ArrayList<Node> variablesVector;

    public K2(ArrayList<Node> variables, int[][] dataBase, int[] vector, long caseNumber, String metric, String param, boolean compacted) {
        this.compacted = compacted;
        this.variablesVector = variables;
        this.dataBase = dataBase;
        this.vector = vector;
        this.caseNumber = caseNumber;
        try {
            this.setMetric(metric);
            double variation = Math.pow(10.0, Integer.parseInt(param));
            boolean continueFlag = false;
            int length = variables.size();
            this.constructPredecessors(this.variablesVector);
            int i = 0;
            while (i < length) {
                continueFlag = true;
                LearningNode variable = (LearningNode)this.variablesVector.get(i);
                double pOld = this.getG(variable, null);
                int parentsLength = variable.getNumeroMaximoPais();
                while (continueFlag && variable.getTamanhoPais() < parentsLength) {
                    Object[] zMax = this.getZMax((LearningNode)variable.clone());
                    LearningNode z = (LearningNode)zMax[0];
                    double pNew = (Double)zMax[1];
                    if (pNew - pOld > variation) {
                        pOld = pNew;
                        this.union(variable.getPais(), z);
                        continue;
                    }
                    continueFlag = false;
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            System.err.println(e.getMessage());
        }
    }
}

