/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.widget.PropertiesTableModel;
import edu.stanford.smi.protege.widget.TextAreaRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;

public class ProtegePropertiesComponent
extends JPanel {
    private SelectableTable _propertiesTable;
    private PropertiesTableModel _propertiesTableModel;
    private LabeledComponent _labeledComponent;
    private JLabel _warningLabel;
    private AllowableAction addAction;
    private AllowableAction viewAction;
    private AllowableAction deleteAction;
    private AllowableAction saveAction;
    private AllowableAction loadAction;
    private File lastDirectory = ApplicationProperties.getLastFileDirectory();
    private File _propertiesFile = null;

    public ProtegePropertiesComponent() {
        this.buildGUI(null);
    }

    public ProtegePropertiesComponent(Properties properties) {
        this.buildGUI(properties);
    }

    public ProtegePropertiesComponent(File file) {
        this.buildGUI(this.loadPropertyFile(file));
    }

    public void buildGUI(Properties properties) {
        this.setLayout(new BorderLayout());
        this._propertiesTable = new SelectableTable(){

            public void editingStopped(ChangeEvent changeEvent) {
                int n;
                int n2 = this.getEditingColumn();
                String string = (String)this.getCellEditor().getCellEditorValue();
                super.editingStopped(changeEvent);
                if (n2 == PropertiesTableModel.getPropertyColumnIndex() && (n = ((PropertiesTableModel)this.getModel()).getRowOfProperty(string)) >= 0) {
                    ComponentUtilities.scrollToVisible(ProtegePropertiesComponent.this._propertiesTable, n, PropertiesTableModel.getValueColumnIndex());
                    ProtegePropertiesComponent.this._propertiesTable.setRowSelectionInterval(n, n);
                    ProtegePropertiesComponent.this._propertiesTable.editCellAt(n, PropertiesTableModel.getValueColumnIndex());
                    ProtegePropertiesComponent.this._propertiesTable.requestFocus();
                }
            }
        };
        this._propertiesTableModel = new PropertiesTableModel(properties);
        this._propertiesTable.setModel(this._propertiesTableModel);
        this._propertiesTable.getColumnModel().getColumn(1).setCellRenderer(new TextAreaRenderer());
        this._propertiesTable.getTableHeader().setReorderingAllowed(false);
        this._labeledComponent = new LabeledComponent("Property Table", new JScrollPane(this._propertiesTable));
        this._warningLabel = new JLabel("", null, 0);
        this.viewAction = this.createViewAction();
        this.addAction = this.createAddAction();
        this.deleteAction = this.createDeleteAction();
        this.saveAction = this.createSaveAction();
        this.loadAction = this.createLoadAction();
        this.saveAction.setName("Save property file as ...");
        this.loadAction.setName("Load property file");
        this._labeledComponent.addHeaderButton(this.viewAction);
        this._labeledComponent.addHeaderButton(this.addAction);
        this._labeledComponent.addHeaderButton(this.deleteAction);
        this._labeledComponent.addHeaderButton(this.saveAction);
        this._labeledComponent.addHeaderButton(this.loadAction);
        this.add((Component)this._warningLabel, "North");
        this.add((Component)this._labeledComponent, "Center");
        this.updateLabel();
    }

    private AllowableAction createViewAction() {
        return new AllowableAction(ResourceKey.VALUE_VIEW, (Selectable)this._propertiesTable){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ProtegePropertiesComponent.this._propertiesTable.getSelectedRow();
                String string = (String)ProtegePropertiesComponent.this._propertiesTable.getValueAt(n, PropertiesTableModel.getPropertyColumnIndex());
                String string2 = (String)ProtegePropertiesComponent.this._propertiesTable.getValueAt(n, PropertiesTableModel.getValueColumnIndex());
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout());
                jPanel.setPreferredSize(new Dimension(300, 100));
                JTextArea jTextArea = new JTextArea();
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setText(string + " = " + string2);
                jTextArea.setEnabled(false);
                jPanel.add(new JScrollPane(jTextArea));
                ModalDialog.showDialog(ProtegePropertiesComponent.this, jPanel, "View property value", 14);
            }
        };
    }

    private AllowableAction createAddAction() {
        return new AllowableAction(ResourceKey.VALUE_ADD){

            public void actionPerformed(ActionEvent actionEvent) {
                ((PropertiesTableModel)ProtegePropertiesComponent.this._propertiesTable.getModel()).addRow("", "");
                ProtegePropertiesComponent.this._propertiesTable.clearSelection();
                ComponentUtilities.scrollToVisible(ProtegePropertiesComponent.this._propertiesTable, 0, 0);
                ProtegePropertiesComponent.this._propertiesTable.setRowSelectionInterval(0, 0);
                ProtegePropertiesComponent.this._propertiesTable.editCellAt(0, 0);
                ProtegePropertiesComponent.this._propertiesTable.requestFocus();
            }
        };
    }

    private AllowableAction createDeleteAction() {
        return new AllowableAction(ResourceKey.VALUE_DELETE, (Selectable)this._propertiesTable){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProtegePropertiesComponent.this._propertiesTable.getCellEditor() != null) {
                    ProtegePropertiesComponent.this._propertiesTable.getCellEditor().stopCellEditing();
                }
                int n = ProtegePropertiesComponent.this._propertiesTable.getSelectedRow();
                ProtegePropertiesComponent.this._propertiesTableModel.deleteRow(n);
                if (ProtegePropertiesComponent.this._propertiesTableModel.getRowCount() > n) {
                    ProtegePropertiesComponent.this._propertiesTable.setRowSelectionInterval(n, n);
                }
            }
        };
    }

    private AllowableAction createSaveAction() {
        return new AllowableAction(ResourceKey.PROJECT_SAVE){

            public void actionPerformed(ActionEvent actionEvent) {
                ProtegePropertiesComponent.this.savePropertyFile();
            }
        };
    }

    private void savePropertyFile() {
        JFileChooser jFileChooser = this.createFileChooser("Save property file", "Property Files", "", false);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (this.savePropertyFile(file)) {
                ModalDialog.showMessageDialog((Component)this, "Property file written out successfully to:\n" + file.getAbsolutePath(), "Property file saved");
            } else {
                ModalDialog.showMessageDialog((Component)this, "Error writing property file", "Error");
            }
        }
    }

    public boolean savePropertyFile(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this._propertiesTableModel.getProperties().store(fileOutputStream, "Generated by ProtegePropertyTab");
            this._propertiesTableModel.setChanged(false);
            return true;
        }
        catch (Exception exception) {
            Log.getLogger().warning("Could not write property file: " + file.getAbsolutePath());
            return false;
        }
    }

    private AllowableAction createLoadAction() {
        return new AllowableAction(ResourceKey.PROJECT_OPEN){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser;
                int n;
                int n2;
                if (ProtegePropertiesComponent.this._propertiesTableModel.isChanged() && (n2 = ModalDialog.showMessageDialog(ProtegePropertiesComponent.this, "Save current properties?", "Save", 13)) == 2) {
                    ProtegePropertiesComponent.this.savePropertyFile();
                }
                if ((n = (jFileChooser = ProtegePropertiesComponent.this.createFileChooser("Load property file", "Property files", "", true)).showOpenDialog(ProtegePropertiesComponent.this)) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    Properties properties = ProtegePropertiesComponent.this.loadPropertyFile(file);
                    ProtegePropertiesComponent.this._propertiesTableModel.setProperties(properties);
                    ProtegePropertiesComponent.this.updateLabel();
                }
            }
        };
    }

    private Properties loadPropertyFile(File file) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            ModalDialog.showMessageDialog((Component)this, "Error loading property file", "Error");
            Log.getLogger().warning("Could not open property file: " + file.getAbsolutePath());
        }
        this._propertiesFile = file;
        return properties;
    }

    public AllowableAction getAddAction() {
        return this.addAction;
    }

    public AllowableAction getDeleteAction() {
        return this.deleteAction;
    }

    public AllowableAction getLoadAction() {
        return this.loadAction;
    }

    public AllowableAction getSaveAction() {
        return this.saveAction;
    }

    public AllowableAction getViewAction() {
        return this.viewAction;
    }

    private JFileChooser createFileChooser(String string, String string2, String string3, final boolean bl) {
        JFileChooser jFileChooser = new JFileChooser(this.lastDirectory){

            public int showDialog(Component component, String string) {
                int n = super.showDialog(component, string);
                if (n == 0) {
                    ProtegePropertiesComponent.this.lastDirectory = this.getCurrentDirectory();
                }
                return n;
            }

            public void approveSelection() {
                String string;
                String string2;
                int n;
                if (bl) {
                    super.approveSelection();
                    return;
                }
                File file = this.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, string2 = "The file '" + file.getName() + "' already exists!\nDo you want to replace it?", string = this.getDialogTitle(), 0, 2)) == 1) {
                    return;
                }
                super.approveSelection();
            }
        };
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        if (string3 != null && string3.length() > 0) {
            String string4 = string2;
            jFileChooser.setFileFilter(new ExtensionFilter(string3, string4));
        }
        return jFileChooser;
    }

    private void updateLabel() {
        String string = "Property Table    (" + (this._propertiesFile == null ? "protege.properties" : this._propertiesFile.getName()) + ")";
        this._labeledComponent.setHeaderLabel(string);
        if (this._propertiesFile != null) {
            this._warningLabel.setToolTipText(this._propertiesFile.getAbsolutePath());
        }
        this._warningLabel.setFont(new Font(null, 1, 12));
        this._warningLabel.setText(this._propertiesFile == null ? "" : "  Changes take effect after restarting " + Text.getProgramName());
        this._warningLabel.setIcon(this._propertiesFile == null ? null : Icons.getIcon(new ResourceKey("warning")));
    }

    public void setVisibleHeaderButton(AllowableAction allowableAction, boolean bl) {
        for (JButton jButton : this._labeledComponent.getHeaderButtons()) {
            if (jButton.getAction() != allowableAction) continue;
            jButton.setVisible(bl);
        }
    }
}

