/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.TransferableCollection;
import edu.stanford.smi.protege.util.TreeTarget;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class TreeDragSourceListener
implements DragGestureListener,
DragSourceListener {
    private Collection _paths;

    public abstract boolean canStartDrag(Collection var1);

    public abstract void doCopy(Collection var1);

    public abstract void doMove(Collection var1);

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (TreeDragSourceListener.dropSucceeded(dragSourceDropEvent)) {
            int n = dragSourceDropEvent.getDropAction();
            if (n == 2) {
                this.doMove(this._paths);
            } else if (n == 1) {
                this.doCopy(this._paths);
            }
        }
    }

    private static boolean dropSucceeded(DragSourceDropEvent dragSourceDropEvent) {
        boolean bl = SystemUtilities.isMac() ? TreeTarget.getLastDropSucceeded() : dragSourceDropEvent.getDropSuccess();
        return bl;
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        JTree jTree = (JTree)dragGestureEvent.getComponent();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        this._paths = treePathArray == null ? Collections.EMPTY_LIST : Arrays.asList(treePathArray);
        Collection collection = ComponentUtilities.getSelection(jTree);
        if (collection != null && this.canStartDrag(collection)) {
            TransferableCollection transferableCollection = new TransferableCollection(collection);
            dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferableCollection, this);
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }
}

