/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.UnaryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtilities {
    public static final ArrayList EMPTY_ARRAY_LIST = new ArrayList();

    public static boolean containSameItems(Collection collection, Collection collection2) {
        Set set = collection instanceof Set ? (Set)collection : new HashSet(collection);
        Set set2 = collection2 instanceof Set ? (Set)collection2 : new HashSet(collection2);
        return ((Object)set).equals(set2);
    }

    public static boolean containsAny(Collection collection, Collection collection2) {
        Collection collection3;
        Collection collection4;
        if (collection.size() < collection2.size()) {
            collection4 = collection;
            collection3 = collection2;
        } else {
            collection4 = collection2;
            collection3 = collection;
        }
        boolean bl = false;
        Iterator iterator = collection4.iterator();
        while (iterator.hasNext()) {
            if (!collection3.contains(iterator.next())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static Collection createCollection(Object object) {
        return CollectionUtilities.createList(object);
    }

    public static List createList(Object object) {
        ArrayList<Object> arrayList;
        if (object == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
        }
        return arrayList;
    }

    public static Map createSmallMap() {
        return new HashMap(11);
    }

    public static boolean equalsSet(Collection collection, Collection collection2) {
        boolean bl;
        if (collection == null) {
            bl = collection2 == null;
        } else if (collection2 == null) {
            bl = false;
        } else if (collection.size() == collection2.size()) {
            bl = true;
            Iterator iterator = collection.iterator();
            while (bl && iterator.hasNext()) {
                Object e = iterator.next();
                bl = collection2.contains(e);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean equalsList(Collection collection, Collection collection2) {
        boolean bl;
        if (collection == null) {
            bl = collection2 == null;
        } else if (collection2 == null) {
            bl = false;
        } else if (collection.size() == collection2.size()) {
            bl = true;
            Iterator iterator = collection.iterator();
            Iterator iterator2 = collection2.iterator();
            while (bl && iterator.hasNext() && iterator2.hasNext()) {
                Object e = iterator.next();
                Object e2 = iterator2.next();
                bl = e.equals(e2);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static Object getFirstItem(Collection collection) {
        Object var1_1 = collection == null || collection.isEmpty() ? null : (collection instanceof List ? ((List)collection).get(0) : collection.iterator().next());
        return var1_1;
    }

    public static Object getSoleItem(Collection collection) {
        Assert.assertEquals("size", collection.size(), 1);
        return CollectionUtilities.getFirstItem(collection);
    }

    public static Collection removeFirst(Collection collection) {
        ArrayList arrayList;
        if (collection == null || collection.size() == 0) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList(collection);
            arrayList.remove(0);
        }
        return arrayList;
    }

    public static String toString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        if (collection != null) {
            boolean bl = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                Object object = iterator.next();
                if (object instanceof Frame) {
                    Frame frame = (Frame)object;
                    if (frame.isDeleted()) {
                        object = "<deleted frame " + frame.getFrameID() + ">";
                    } else {
                        object = frame.getBrowserText();
                        if (object == null) {
                            object = "<null browser text on " + frame.getFrameID() + ">";
                        }
                    }
                }
                stringBuffer.append(object);
            }
        }
        return stringBuffer.toString();
    }

    public static void apply(Collection collection, UnaryFunction unaryFunction) {
        for (Object e : collection) {
            unaryFunction.apply(e);
        }
    }
}

