/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import java.util.Collection;
import java.util.Comparator;

public class SlotSubslotNode
extends LazyTreeNode {
    private FrameListener _frameListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent frameEvent) {
            SlotSubslotNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            String string = frameEvent.getSlot().getName();
            if (string.equals(":DIRECT-SUBSLOTS")) {
                SlotSubslotNode.this.reload();
            } else if (string.equals(":DIRECT-TYPE")) {
                Slot slot = SlotSubslotNode.this.getSlot().getKnowledgeBase().getSlot(SlotSubslotNode.this.getSlot().getName());
                SlotSubslotNode.this.reload(slot);
            }
        }
    };

    public SlotSubslotNode(LazyTreeNode lazyTreeNode, Slot slot) {
        super(lazyTreeNode, slot);
        slot.addFrameListener(this._frameListener);
    }

    protected LazyTreeNode createNode(Object object) {
        return new SlotSubslotNode((LazyTreeNode)this, (Slot)object);
    }

    protected void dispose() {
        super.dispose();
        this.getSlot().removeFrameListener(this._frameListener);
    }

    protected int getChildObjectCount() {
        return this.getSlot().getDirectSubslotCount();
    }

    protected Collection getChildObjects() {
        return this.getSlot().getDirectSubslots();
    }

    protected Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    protected Slot getSlot() {
        return (Slot)this.getUserObject();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }

    public String toString() {
        return "SlotSubslotNode(" + this.getSlot() + ")";
    }
}

