/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.test;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.test.AbstractTestCase;
import edu.stanford.smi.protege.test.ClipsProjectFactory;
import edu.stanford.smi.protege.test.TestUtilities;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class UITestCase
extends AbstractTestCase {
    public Project getProject() {
        return ProjectManager.getProjectManager().getCurrentProject();
    }

    public static void pressButton(Component component, Icon icon) {
        UITestCase.assertNotNull((Object)component);
        UITestCase.assertNotNull((Object)icon);
        TestUtilities.pressButton(component, icon);
    }

    protected static void pressToolBarButton(Icon icon) {
        JToolBar jToolBar = UITestCase.getSystemToolBar();
        UITestCase.assertNotNull((Object)jToolBar);
        UITestCase.pressButton(jToolBar, icon);
    }

    protected static JToolBar getSystemToolBar() {
        return ProjectManager.getProjectManager().getCurrentProjectMainToolBar();
    }

    protected static Component getTopWindow() {
        Window window = FocusManager.getCurrentManager().getActiveWindow();
        UITestCase.assertNotNull((Object)window);
        return window;
    }

    protected static Component getMainWindow() {
        return ProjectManager.getProjectManager().getMainPanel();
    }

    protected static void delaySeconds(int n) {
        try {
            Thread.sleep((long)n * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static void sync() {
        Toolkit.getDefaultToolkit().sync();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected static void setLabeledComponentText(Component component, String string, String string2) {
        UITestCase.assertNotNull((Object)component);
        UITestCase.sync();
        boolean bl = false;
        for (LabeledComponent labeledComponent : ComponentUtilities.getDescendentsOfClass(LabeledComponent.class, component)) {
            String string3 = labeledComponent.getHeaderLabel().toLowerCase();
            if (!string3.startsWith(string.toLowerCase())) continue;
            Component component2 = labeledComponent.getCenterComponent();
            if (component2 instanceof JScrollPane) {
                component2 = ((JScrollPane)component2).getViewport().getView();
            }
            UITestCase.assertTrue((boolean)(component2 instanceof JTextComponent));
            JTextComponent jTextComponent = (JTextComponent)component2;
            jTextComponent.setText(string2);
            bl = true;
            break;
        }
        UITestCase.assertTrue((boolean)bl);
        UITestCase.sync();
    }

    protected static void executeOnNextModalDialog(final Runnable runnable) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    ModalDialog modalDialog = null;
                    while (modalDialog == null) {
                        modalDialog = ModalDialog.getCurrentDialog();
                        if (modalDialog != null && modalDialog.isVisible()) {
                            UITestCase.sync();
                            SystemUtilities.sleepMsec(250);
                            runnable.run();
                            return;
                        }
                        SystemUtilities.sleepMsec(250);
                    }
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    protected static void setSelectionOnTree(Icon icon, Object[] objectArray) {
        TestUtilities.setSelectionOnTree(UITestCase.getMainWindow(), icon, objectArray);
    }

    protected static Object[] getSelectionOnTree(Icon icon) {
        return TestUtilities.getSelectionOnTree(UITestCase.getMainWindow(), icon);
    }

    protected static JTree getTreeOnTab(Icon icon) {
        return TestUtilities.getTreeOnTab(UITestCase.getMainWindow(), icon);
    }

    protected static void unpressToolBarButton(Icon icon) {
        UITestCase.sync();
        AbstractButton abstractButton = UITestCase.getToolBarButton(icon);
        UITestCase.assertNotNull((Object)abstractButton);
        if (abstractButton.isSelected()) {
            abstractButton.doClick();
        }
    }

    protected static AbstractButton getToolBarButton(Icon icon) {
        return TestUtilities.getButton(UITestCase.getSystemToolBar(), icon);
    }

    static {
        ClipsProjectFactory clipsProjectFactory = new ClipsProjectFactory();
        Project project = clipsProjectFactory.createProject();
        project = clipsProjectFactory.saveAndReloadProject(project);
        URI uRI = project.getProjectURI();
        project.dispose();
        Application.main(new String[]{uRI.toString()});
    }
}

