/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.storage.clips.ClipsFileWriter;
import edu.stanford.smi.protege.storage.clips.ClipsUtil;
import edu.stanford.smi.protege.ui.FrameNameComparator;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class InstanceStorer
extends ClipsFileWriter {
    private Collection _errors;
    private Map _clsToSlotsMap = new HashMap();
    private Slot _constraintsSlot;
    private Map clsToSlotToValueTypeMap = new HashMap();
    private Set _slotNamesToNotSaveForClsesAndSlots = new HashSet();
    private Set _slotNamesNeverToSave = new HashSet();
    private Map clsToSlotToBooleanMap;

    public InstanceStorer(Writer writer) {
        super(writer);
        this._slotNamesToNotSaveForClsesAndSlots.add(":NAME");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-TYPE");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-INSTANCES");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-SUPERCLASSES");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-SUBCLASSES");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-TEMPLATE-SLOTS");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-DOMAIN");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DOCUMENTATION");
        this._slotNamesToNotSaveForClsesAndSlots.add(":ROLE");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-VALUE-TYPE");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-MINIMUM-CARDINALITY");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-MAXIMUM-CARDINALITY");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-NUMERIC-MINIMUM");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-NUMERIC-MAXIMUM");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-DEFAULTS");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-VALUES");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-INVERSE");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-SUBSLOTS");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-SUPERSLOTS");
        this._slotNamesNeverToSave.add(":NAME");
        this._slotNamesNeverToSave.add(":DIRECT-TYPE");
        this.clsToSlotToBooleanMap = new HashMap();
    }

    private static Collection anyToStrings(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : collection) {
            String string = e instanceof Frame ? "[" + InstanceStorer.toExternalFrameName((Frame)e) + "]" : (e instanceof String ? ClipsUtil.toExternalString((String)e) : (e instanceof Boolean ? ((Boolean)e != false ? "TRUE" : "FALSE") : e.toString()));
            arrayList.add(string);
        }
        return arrayList;
    }

    private static Collection booleansToStrings(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Boolean bl : collection) {
            String string = bl != false ? "TRUE" : "FALSE";
            arrayList.add(string);
        }
        return arrayList;
    }

    private static Collection clsesToStrings(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : collection) {
            if (e instanceof Cls) {
                Cls cls = (Cls)e;
                arrayList.add(InstanceStorer.toExternalFrameName(cls));
                continue;
            }
            Log.getLogger().warning("not a class: " + e);
        }
        return arrayList;
    }

    private Collection getSlots(Instance instance) {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (Cls cls : instance.getDirectTypes()) {
            ArrayList<Slot> arrayList2 = (ArrayList<Slot>)this._clsToSlotsMap.get(cls);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Slot>(cls.getTemplateSlots());
                Collections.sort(arrayList2);
                this._clsToSlotsMap.put(cls, arrayList2);
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private boolean hasConstraintSlotValues(Instance instance) {
        if (this._constraintsSlot == null) {
            this._constraintsSlot = (Slot)instance.getKnowledgeBase().getFrame(":SLOT-CONSTRAINTS");
        }
        return instance.getOwnSlotValueCount(this._constraintsSlot) != 0;
    }

    private static Collection instancesToStrings(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Instance instance : collection) {
            arrayList.add("[" + InstanceStorer.toExternalFrameName(instance) + "]");
        }
        return arrayList;
    }

    private static Collection internalToExternalStrings(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            if (string.length() <= 0) continue;
            arrayList.add(ClipsUtil.toExternalString(string));
        }
        return arrayList;
    }

    private static Collection internalToExternalSymbols(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            if (string.length() <= 0) continue;
            arrayList.add(ClipsUtil.toExternalSymbol(string));
        }
        return arrayList;
    }

    private static boolean isStandardClsSlot(Instance instance) {
        Collection collection = instance.getDirectTypes();
        boolean bl = false;
        if (collection.size() == 1) {
            Cls cls = instance.getDirectType();
            FrameID frameID = cls.getFrameID();
            bl = InstanceStorer.equals(frameID, Model.ClsID.STANDARD_CLASS) || InstanceStorer.equals(frameID, Model.ClsID.STANDARD_SLOT);
        }
        return bl;
    }

    protected boolean isStorableInstance(Instance instance) {
        boolean bl = false;
        if (instance.isDeleted()) {
            Log.getLogger().warning("has been deleted: " + instance.getName());
        } else if (instance.getDirectType() == null) {
            Log.getLogger().warning("null type: " + instance.getName());
        } else if (InstanceStorer.isStandardClsSlot(instance)) {
            bl = this.hasConstraintSlotValues(instance);
        } else if (instance.getName() == null) {
            Log.getLogger().warning("null name: " + instance.hashCode());
        } else {
            bl = !instance.isIncluded();
        }
        return bl;
    }

    protected boolean isStorableSlot(Instance instance, Slot slot) {
        boolean bl = instance instanceof Cls || instance instanceof Slot ? !this._slotNamesToNotSaveForClsesAndSlots.contains(slot.getName()) : !this._slotNamesNeverToSave.contains(slot.getName());
        return bl;
    }

    private void printValues(Slot slot, Collection collection, boolean bl, boolean bl2) {
        this.println();
        this.print("\t(");
        this.printFrame(slot);
        if (collection.size() == 1 || !bl2) {
            this.print(" ");
            this.print(collection.iterator().next().toString());
            this.print(")");
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    this.println();
                    this.print("\t\t");
                } else {
                    this.print(" ");
                }
                String string = iterator.next().toString();
                this.print(string);
            }
            this.print(")");
        }
    }

    private void storeInstance(Instance instance) {
        try {
            if (this.isStorableInstance(instance)) {
                this.println();
                this.print("([");
                this.printFrame(instance);
                this.print("] of ");
                this.printTypes(instance);
                this.storeSlotValues(instance);
                this.println(")");
            }
        }
        catch (Exception exception) {
            String string = "Errors at storing instance " + instance;
            Log.getLogger().log(Level.WARNING, string, exception);
            this._errors.add(new MessageError(exception, string));
        }
    }

    private void printTypes(Instance instance) {
        Collection collection = instance.getDirectTypes();
        for (Cls cls : collection) {
            this.print(" ");
            this.printFrame(cls);
        }
        this.println();
    }

    public void storeInstances(KnowledgeBase knowledgeBase, Collection collection) {
        this._errors = collection;
        ArrayList arrayList = new ArrayList(knowledgeBase.getInstances());
        Collections.sort(arrayList, new FrameNameComparator());
        for (Instance instance : arrayList) {
            this.storeInstance(instance);
        }
        this.flush();
        if (!this.printSucceeded()) {
            collection.add(new MessageError("Store instances failed"));
            Log.getLogger().warning("Store instances failed");
        }
    }

    private void storeSlotValue(Instance instance, Slot slot, boolean bl) {
        try {
            Collection collection = instance.getDirectOwnSlotValues(slot);
            if (!collection.isEmpty()) {
                boolean bl2 = false;
                ValueType valueType = this.getValueType(instance, slot);
                if (InstanceStorer.equals(valueType, ValueType.BOOLEAN)) {
                    collection = InstanceStorer.booleansToStrings(collection);
                } else if (InstanceStorer.equals(valueType, ValueType.INSTANCE)) {
                    collection = InstanceStorer.instancesToStrings(collection);
                    bl2 = true;
                } else if (InstanceStorer.equals(valueType, ValueType.CLS)) {
                    collection = InstanceStorer.clsesToStrings(collection);
                    bl2 = true;
                } else if (InstanceStorer.equals(valueType, ValueType.STRING)) {
                    collection = InstanceStorer.internalToExternalStrings(collection);
                    bl2 = true;
                } else if (InstanceStorer.equals(valueType, ValueType.SYMBOL)) {
                    collection = InstanceStorer.internalToExternalSymbols(collection);
                } else if (InstanceStorer.equals(valueType, ValueType.ANY)) {
                    collection = InstanceStorer.anyToStrings(collection);
                }
                if (!collection.isEmpty()) {
                    this.printValues(slot, collection, bl2, bl);
                }
            }
        }
        catch (Exception exception) {
            String string = "Errors at storing slot " + slot + " at instance " + instance;
            Log.getLogger().log(Level.WARNING, string, exception);
            this._errors.add(new MessageError(exception, string));
        }
    }

    private void storeSlotValues(Instance instance) {
        for (Slot slot : this.getSlots(instance)) {
            if (!this.isStorableSlot(instance, slot)) continue;
            boolean bl = this.getAllowsMultipleValues(instance, slot);
            this.storeSlotValue(instance, slot, bl);
        }
    }

    private boolean getAllowsMultipleValues(Instance instance, Slot slot) {
        Boolean bl;
        Collection collection = instance.getDirectTypes();
        if (collection.size() == 1) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
            HashMap<Slot, Boolean> hashMap = (HashMap<Slot, Boolean>)this.clsToSlotToBooleanMap.get(cls);
            if (hashMap == null) {
                hashMap = new HashMap<Slot, Boolean>();
                this.clsToSlotToBooleanMap.put(cls, hashMap);
            }
            if ((bl = (Boolean)hashMap.get(slot)) == null) {
                boolean bl2 = instance.getOwnSlotAllowsMultipleValues(slot);
                bl = bl2;
                hashMap.put(slot, bl);
            }
        } else {
            bl = instance.getOwnSlotAllowsMultipleValues(slot);
        }
        return bl;
    }

    private ValueType getValueType(Instance instance, Slot slot) {
        ValueType valueType;
        Collection collection = instance.getDirectTypes();
        if (collection.size() == 1) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
            HashMap<Slot, ValueType> hashMap = (HashMap<Slot, ValueType>)this.clsToSlotToValueTypeMap.get(cls);
            if (hashMap == null) {
                hashMap = new HashMap<Slot, ValueType>();
                this.clsToSlotToValueTypeMap.put(cls, hashMap);
            }
            if ((valueType = (ValueType)hashMap.get(slot)) == null) {
                valueType = instance.getOwnSlotValueType(slot);
                hashMap.put(slot, valueType);
            }
        } else {
            valueType = instance.getOwnSlotValueType(slot);
        }
        return valueType;
    }
}

