/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;

public class ServerRmiSocketFactory
extends RMISocketFactory {
    private int fixedPort = Integer.getInteger("protege.rmi.server.port", 0);

    public ServerRmiSocketFactory() {
        if (this.fixedPort != 0) {
            Log.getLogger().config("fixed port=" + this.fixedPort);
        }
    }

    public Socket createSocket(String string, int n) throws IOException {
        Socket socket = new Socket(string, n);
        if (this.fixedPort != 0) {
            Log.getLogger().config("local port: " + socket.getLocalPort());
        }
        return socket;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        int n2 = n == 0 ? this.fixedPort : n;
        ServerSocket serverSocket = new ServerSocket(n2);
        if (this.fixedPort != 0) {
            Log.getLogger().config("local port: " + serverSocket.getLocalPort());
        }
        return serverSocket;
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

