/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.BackendExportPlugin;
import edu.stanford.smi.protege.plugin.ChangeProjectFormatWizardPage;
import edu.stanford.smi.protege.plugin.ExportPluginRenderer;
import edu.stanford.smi.protege.plugin.ExportProjectPlugin;
import edu.stanford.smi.protege.plugin.ExportWizard;
import edu.stanford.smi.protege.plugin.ExportWizardPage;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class SelectOutputFormatWizardPage
extends ExportWizardPage {
    private static final String SELECTED_PLUGIN = "export_project.last_selected_plugin";
    private SelectableList list;
    private Project project;

    SelectOutputFormatWizardPage(ExportWizard exportWizard, Project project) {
        super("select output format", exportWizard);
        this.project = project;
        JLabel jLabel = ComponentFactory.createSmallFontLabel("Select an Output Format:");
        jLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)jLabel, "North");
        this.list = this.createList();
        this.add((Component)ComponentFactory.createScrollPane(this.list), "Center");
    }

    private SelectableList createList() {
        ArrayList<ExportProjectPlugin> arrayList = new ArrayList<ExportProjectPlugin>();
        ExportProjectPlugin exportProjectPlugin = null;
        String string = ApplicationProperties.getString(SELECTED_PLUGIN);
        for (String string2 : PluginUtilities.getAvailableExportProjectPluginClassNames()) {
            ExportProjectPlugin exportProjectPlugin2 = (ExportProjectPlugin)SystemUtilities.newInstance(string2);
            if (!exportProjectPlugin2.canExport(this.project)) continue;
            arrayList.add(exportProjectPlugin2);
            if (!exportProjectPlugin2.getClass().getName().equals(string)) continue;
            exportProjectPlugin = exportProjectPlugin2;
        }
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setModel(new SimpleListModel(arrayList));
        this.list.setCellRenderer(new ExportPluginRenderer());
        if (exportProjectPlugin == null) {
            this.list.setSelectedIndex(0);
        } else {
            this.list.setSelectedValue(exportProjectPlugin);
        }
        this.list.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                SelectOutputFormatWizardPage.this.updateNextPage();
            }
        });
        return this.list;
    }

    public ExportProjectPlugin getSelectedPlugin() {
        ExportProjectPlugin exportProjectPlugin = (ExportProjectPlugin)this.list.getSelectedValue();
        ApplicationProperties.setString(SELECTED_PLUGIN, exportProjectPlugin.getClass().getName());
        return exportProjectPlugin;
    }

    public WizardPage getNextPage() {
        ExportProjectPlugin exportProjectPlugin = this.getSelectedPlugin();
        WizardPage wizardPage = null;
        wizardPage = this.canChangeFormat(exportProjectPlugin) ? new ChangeProjectFormatWizardPage(this.getExportProjectWizard(), (BackendExportPlugin)exportProjectPlugin, this.project) : exportProjectPlugin.createExportWizardPage(this.getExportProjectWizard(), this.project);
        return wizardPage;
    }

    private boolean canChangeFormat(ExportProjectPlugin exportProjectPlugin) {
        boolean bl = false;
        if (exportProjectPlugin instanceof BackendExportPlugin) {
            BackendExportPlugin backendExportPlugin = (BackendExportPlugin)exportProjectPlugin;
            bl = backendExportPlugin.canExportToNewFormat(this.project);
        }
        return bl;
    }

    public void onFinish() {
        ExportWizard exportWizard = (ExportWizard)this.getWizard();
        exportWizard.setExportPlugin(this.getSelectedPlugin());
    }
}

