/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.plugin.ProjectPlugin;
import edu.stanford.smi.protege.ui.ProjectMenuBar;
import edu.stanford.smi.protege.ui.ProjectToolBar;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public class ProjectPluginManager {
    private static final String IS_SUITABLE_METHOD_NAME = "isSuitable";
    private static final Class[] IS_SUITABLE_METHOD_ARGS = new Class[]{Project.class, Collection.class};
    private Collection projectPlugins = new ArrayList();

    public ProjectPluginManager() {
        for (String string : PluginUtilities.getAvailableProjectPluginClassNames()) {
            ProjectPlugin projectPlugin = (ProjectPlugin)SystemUtilities.newInstance(string);
            if (projectPlugin == null) continue;
            this.projectPlugins.add(projectPlugin);
        }
    }

    public void dispose() {
        for (ProjectPlugin projectPlugin : this.projectPlugins) {
            projectPlugin.dispose();
        }
        this.projectPlugins.clear();
        this.projectPlugins = null;
    }

    public void afterCreate(Project project) {
        for (ProjectPlugin projectPlugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, projectPlugin)) continue;
            projectPlugin.afterCreate(project);
        }
    }

    public void afterLoad(Project project) {
        for (ProjectPlugin projectPlugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, projectPlugin)) continue;
            projectPlugin.afterLoad(project);
        }
    }

    private static boolean isSuitable(Project project, ProjectPlugin projectPlugin) {
        boolean bl;
        try {
            ArrayList arrayList = new ArrayList();
            Method method = projectPlugin.getClass().getMethod(IS_SUITABLE_METHOD_NAME, IS_SUITABLE_METHOD_ARGS);
            Boolean bl2 = (Boolean)method.invoke((Object)projectPlugin, project, arrayList);
            bl = bl2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            Log.getLogger().warning(exception.getMessage());
        }
        return bl;
    }

    private static boolean isSuitable(ProjectView projectView, ProjectPlugin projectPlugin) {
        return ProjectPluginManager.isSuitable(projectView.getProject(), projectPlugin);
    }

    public void afterSave(Project project) {
        for (ProjectPlugin projectPlugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, projectPlugin)) continue;
            try {
                projectPlugin.afterSave(project);
            }
            catch (AbstractMethodError abstractMethodError) {
                Log.getLogger().warning("Plugin " + projectPlugin + " does not implement the afterSave method");
            }
        }
    }

    public void afterShow(ProjectView projectView, ProjectToolBar projectToolBar, ProjectMenuBar projectMenuBar) {
        for (ProjectPlugin projectPlugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(projectView, projectPlugin)) continue;
            try {
                projectPlugin.afterShow(projectView, projectToolBar, projectMenuBar);
            }
            catch (Exception exception) {
                Log.getLogger().warning(exception.toString());
                Log.getLogger().log(Level.FINE, "Exception caught", exception);
            }
        }
    }

    public void beforeSave(Project project) {
        for (ProjectPlugin projectPlugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, projectPlugin)) continue;
            projectPlugin.beforeSave(project);
        }
    }

    public void beforeClose(Project project) {
        for (ProjectPlugin projectPlugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, projectPlugin)) continue;
            projectPlugin.beforeClose(project);
        }
    }

    public void beforeHide(ProjectView projectView, ProjectToolBar projectToolBar, ProjectMenuBar projectMenuBar) {
        for (ProjectPlugin projectPlugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(projectView, projectPlugin)) continue;
            projectPlugin.beforeHide(projectView, projectToolBar, projectMenuBar);
        }
    }
}

