/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;

class MoveDirectSubclassCommand
extends AbstractCommand {
    private Cls cls;
    private int index;
    private Cls subclass;
    private int oldIndex;

    MoveDirectSubclassCommand(FrameStore frameStore, Cls cls, int n, Cls cls2) {
        super(frameStore);
        this.cls = cls;
        this.index = n;
        this.subclass = cls2;
        this.oldIndex = this.getDelegate().getDirectSubclasses(cls).indexOf(cls2);
        this.setDescription("Move subclass " + MoveDirectSubclassCommand.getText(cls2) + " of class " + MoveDirectSubclassCommand.getText(cls) + " to index " + n);
    }

    public Object doIt() {
        this.getDelegate().moveDirectSubclass(this.cls, this.subclass, this.index);
        return null;
    }

    public void undoIt() {
        this.getDelegate().moveDirectSubclass(this.cls, this.subclass, this.oldIndex);
    }

    public void redoIt() {
        this.getDelegate().moveDirectSubclass(this.cls, this.subclass, this.index);
    }
}

