/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.HashUtils;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class Record {
    private Frame frame;
    private Slot slot;
    private Facet facet;
    private boolean isTemplate;
    private List values;
    private int hashCode;

    public Record(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this.set(frame, slot, facet, bl);
        this.setValues(collection);
    }

    Record() {
    }

    void set(Frame frame, Slot slot, Facet facet, boolean bl) {
        this.frame = frame;
        this.slot = slot;
        this.facet = facet;
        this.isTemplate = bl;
        this.hashCode = HashUtils.getHash(frame, slot, facet, bl);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public Facet getFacet() {
        return this.facet;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public List getInternalValues() {
        return this.values;
    }

    public int getValueCount() {
        return this.values.size();
    }

    public List getValues() {
        return this.values.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(this.values);
    }

    public void setValues(Collection collection) {
        this.values = new ArrayList(collection);
    }

    public void addValue(Object object) {
        this.values.add(object);
    }

    public boolean removeValue(Object object) {
        return this.values.remove(object);
    }

    public void moveValue(int n, int n2) {
        Object e = this.values.remove(n);
        this.values.add(n2, e);
    }

    public void replaceFrameReference(Frame frame) {
        if (frame.equals(this.frame)) {
            this.frame = frame;
        }
        if (frame.equals(this.slot)) {
            this.slot = (Slot)frame;
        }
        if (frame.equals(this.facet)) {
            this.facet = (Facet)frame;
        }
    }

    public void replaceFrameValue(Frame frame) {
        ListIterator<Frame> listIterator = this.values.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!frame.equals(e)) continue;
            listIterator.set(frame);
        }
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Record) {
            Record record = (Record)object;
            bl = Record.equals(this.frame, record.frame) && Record.equals(this.slot, record.slot) && Record.equals(this.facet, record.facet) && this.isTemplate == record.isTemplate;
        }
        return bl;
    }

    private static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }
}

